/*
 * Decompiled with CFR 0.152.
 */
package runwar.options;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ServerOptions {
    private String serverName = "default";
    private String processName = "RunWAR";
    private String loglevel = "WARN";
    private String host = "127.0.0.1";
    private String contextPath = "/";
    private int portNumber = 8088;
    private int ajpPort = 8009;
    private int sslPort = 443;
    private int socketNumber = 8779;
    private boolean enableAJP = false;
    private boolean enableSSL = false;
    private boolean enableHTTP = true;
    private boolean enableURLRewrite = false;
    private boolean debug = false;
    private boolean isBackground = true;
    private boolean keepRequestLog = false;
    private boolean openbrowser = false;
    private String pidFile;
    private String openbrowserURL;
    private String cfmlDirs;
    private String libDirs = null;
    private int launchTimeout = 50000;
    private URL jarURL = null;
    private File warFile;
    private File webXmlFile;
    private File logDir;
    private File urlRewriteFile;
    private File trayConfig;
    private File statusFile = null;
    private String iconImage = null;
    private String cfmlServletConfigWebDir = null;
    private String cfmlServletConfigServerDir = null;
    private boolean directoryListingEnabled = true;
    private boolean cacheEnabled = false;
    private String[] welcomeFiles = new String[]{"index.cfm", "index.cfml", "default.cfm", "index.html", "index.htm", "default.html", "default.htm"};
    private File sslCertificate;
    private File sslKey;
    private File configFile;
    private char[] sslKeyPass;
    private char[] stopPassword = "klaatuBaradaNikto".toCharArray();
    private String action;
    private String cfengineName = "lucee";
    private boolean customHTTPStatusEnabled = true;
    private boolean gzipEnabled = false;
    private Long transferMinSize = 100L;
    private boolean mariadb4jEnabled = false;
    private int mariadb4jPort = 13306;
    private File mariadb4jBaseDir;
    private File mariadb4jDataDir;
    private File mariadb4jImportSQLFile = null;

    public String getServerName() {
        return this.serverName;
    }

    public ServerOptions setServerName(String string) {
        this.serverName = string;
        return this;
    }

    public String getLoglevel() {
        return this.loglevel;
    }

    public ServerOptions setLoglevel(String string) {
        this.loglevel = string.toUpperCase();
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public ServerOptions setConfigFile(File file) {
        this.configFile = file;
        return this;
    }

    public ServerOptions setContextPath(String string) {
        this.contextPath = string;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ServerOptions setHost(String string) {
        this.host = string;
        return this;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public ServerOptions setPortNumber(int n) {
        this.portNumber = n;
        return this;
    }

    public int getAJPPort() {
        return this.ajpPort;
    }

    public ServerOptions setAJPPort(int n) {
        this.ajpPort = n;
        return this;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public ServerOptions setSSLPort(int n) {
        this.sslPort = n;
        return this;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public ServerOptions setEnableSSL(boolean bl) {
        this.enableSSL = bl;
        return this;
    }

    public boolean isEnableHTTP() {
        return this.enableHTTP;
    }

    public ServerOptions setEnableHTTP(boolean bl) {
        this.enableHTTP = bl;
        return this;
    }

    public boolean isEnableURLRewrite() {
        return this.enableURLRewrite;
    }

    public ServerOptions setEnableURLRewrite(boolean bl) {
        this.enableURLRewrite = bl;
        return this;
    }

    public ServerOptions setURLRewriteFile(File file) {
        this.urlRewriteFile = file;
        return this;
    }

    public File getURLRewriteFile() {
        return this.urlRewriteFile;
    }

    public int getSocketNumber() {
        return this.socketNumber;
    }

    public ServerOptions setSocketNumber(int n) {
        this.socketNumber = n;
        return this;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public ServerOptions setLogDir(String string) {
        if (string != null && string.length() > 0) {
            this.logDir = new File(string);
        }
        return this;
    }

    public ServerOptions setLogDir(File file) {
        this.logDir = file;
        return this;
    }

    public String getCfmlDirs() {
        return this.cfmlDirs;
    }

    public ServerOptions setCfmlDirs(String string) {
        this.cfmlDirs = string;
        return this;
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public ServerOptions setBackground(boolean bl) {
        this.isBackground = bl;
        return this;
    }

    public boolean isKeepRequestLog() {
        return this.keepRequestLog;
    }

    public ServerOptions setKeepRequestLog(boolean bl) {
        this.keepRequestLog = bl;
        return this;
    }

    public boolean isOpenbrowser() {
        return this.openbrowser;
    }

    public ServerOptions setOpenbrowser(boolean bl) {
        this.openbrowser = bl;
        return this;
    }

    public String getOpenbrowserURL() {
        return this.openbrowserURL;
    }

    public ServerOptions setOpenbrowserURL(String string) {
        this.openbrowserURL = string;
        return this;
    }

    public String getPidFile() {
        return this.pidFile;
    }

    public ServerOptions setPidFile(String string) {
        this.pidFile = string;
        return this;
    }

    public boolean isEnableAJP() {
        return this.enableAJP;
    }

    public ServerOptions setEnableAJP(boolean bl) {
        this.enableAJP = bl;
        return this;
    }

    public int getLaunchTimeout() {
        return this.launchTimeout;
    }

    public ServerOptions setLaunchTimeout(int n) {
        this.launchTimeout = n;
        return this;
    }

    public String getProcessName() {
        return this.processName;
    }

    public ServerOptions setProcessName(String string) {
        this.processName = string;
        return this;
    }

    public String getLibDirs() {
        return this.libDirs;
    }

    public ServerOptions setLibDirs(String string) {
        this.libDirs = string;
        return this;
    }

    public URL getJarURL() {
        return this.jarURL;
    }

    public ServerOptions setJarURL(URL uRL) {
        this.jarURL = uRL;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ServerOptions setDebug(boolean bl) {
        this.debug = bl;
        return this;
    }

    public File getWarFile() {
        return this.warFile;
    }

    public ServerOptions setWarFile(File file) {
        this.warFile = file;
        return this;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public String getWebXmlPath() throws MalformedURLException {
        return this.webXmlFile.toURI().toURL().toString();
    }

    public ServerOptions setWebXmlFile(File file) {
        this.webXmlFile = file;
        return this;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public ServerOptions setIconImage(String string) {
        this.iconImage = string;
        return this;
    }

    public File getTrayConfig() {
        return this.trayConfig;
    }

    public ServerOptions setTrayConfig(File file) {
        this.trayConfig = file;
        return this;
    }

    public File getStatusFile() {
        return this.statusFile;
    }

    public ServerOptions setStatusFile(File file) {
        this.statusFile = file;
        return this;
    }

    public String getCFMLServletConfigWebDir() {
        return this.cfmlServletConfigWebDir;
    }

    public ServerOptions setCFMLServletConfigWebDir(String string) {
        this.cfmlServletConfigWebDir = string;
        return this;
    }

    public String getCFMLServletConfigServerDir() {
        return this.cfmlServletConfigServerDir;
    }

    public ServerOptions setCFMLServletConfigServerDir(String string) {
        this.cfmlServletConfigServerDir = string;
        return this;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public ServerOptions setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
        return this;
    }

    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ServerOptions setDirectoryListingEnabled(boolean bl) {
        this.directoryListingEnabled = bl;
        return this;
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public ServerOptions setWelcomeFiles(String[] stringArray) {
        this.welcomeFiles = stringArray;
        return this;
    }

    public String getWarPath() throws MalformedURLException {
        return this.getWarFile().toURI().toURL().toString();
    }

    public ServerOptions setSSLCertificate(File file) {
        this.sslCertificate = file;
        return this;
    }

    public File getSSLCertificate() {
        return this.sslCertificate;
    }

    public ServerOptions setSSLKey(File file) {
        this.sslKey = file;
        return this;
    }

    public File getSSLKey() {
        return this.sslKey;
    }

    public ServerOptions setSSLKeyPass(char[] cArray) {
        this.sslKeyPass = cArray;
        return this;
    }

    public char[] getSSLKeyPass() {
        return this.sslKeyPass;
    }

    public ServerOptions setStopPassword(char[] cArray) {
        this.stopPassword = cArray;
        return this;
    }

    public char[] getStopPassword() {
        return this.stopPassword;
    }

    public ServerOptions setAction(String string) {
        this.action = string;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public ServerOptions setCFEngineName(String string) {
        if (!(string.toLowerCase().equals("lucee") || string.toLowerCase().equals("adobe") || string.toLowerCase().equals("railo") || string.toLowerCase().equals(""))) {
            throw new RuntimeException("Unknown engine type: " + string + ", must be one of: lucee, adobe, railo");
        }
        this.cfengineName = string.toLowerCase();
        return this;
    }

    public String getCFEngineName() {
        return this.cfengineName;
    }

    public ServerOptions setCustomHTTPStatusEnabled(boolean bl) {
        this.customHTTPStatusEnabled = bl;
        return this;
    }

    public boolean isCustomHTTPStatusEnabled() {
        return this.customHTTPStatusEnabled;
    }

    public ServerOptions setSendfileEnabled(boolean bl) {
        if (!bl) {
            this.transferMinSize = Long.MAX_VALUE;
        }
        return this;
    }

    public ServerOptions setTransferMinSize(Long l) {
        this.transferMinSize = l;
        return this;
    }

    public Long getTransferMinSize() {
        return this.transferMinSize;
    }

    public ServerOptions setGzipEnabled(boolean bl) {
        this.gzipEnabled = bl;
        return this;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public ServerOptions setMariaDB4jEnabled(boolean bl) {
        this.mariadb4jEnabled = bl;
        return this;
    }

    public boolean isMariaDB4jEnabled() {
        return this.mariadb4jEnabled;
    }

    public ServerOptions setMariaDB4jPort(int n) {
        this.mariadb4jPort = n;
        return this;
    }

    public int getMariaDB4jPort() {
        return this.mariadb4jPort;
    }

    public ServerOptions setMariaDB4jBaseDir(File file) {
        this.mariadb4jBaseDir = file;
        return this;
    }

    public File getMariaDB4jBaseDir() {
        return this.mariadb4jBaseDir;
    }

    public ServerOptions setMariaDB4jDataDir(File file) {
        this.mariadb4jDataDir = file;
        return this;
    }

    public File getMariaDB4jDataDir() {
        return this.mariadb4jDataDir;
    }

    public ServerOptions setMariaDB4jImportSQLFile(File file) {
        this.mariadb4jImportSQLFile = file;
        return this;
    }

    public File getMariaDB4jImportSQLFile() {
        return this.mariadb4jImportSQLFile;
    }
}

