/*
 * Decompiled with CFR 0.152.
 */
package runwar.undertow;

import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import runwar.logging.Logger;

public class MappedResourceManager
extends FileResourceManager {
    private static Logger log = Logger.getLogger("RunwarLogger");
    private HashMap<String, File> aliasMap = new HashMap();
    private File[] cfmlDirsFiles;
    private File WEBINF = null;

    public MappedResourceManager(File file, long l, String string) {
        super(file, l);
        this.processMappings(string);
    }

    public MappedResourceManager(File file, long l, String string, File file2) {
        this(file, l, string);
        this.WEBINF = file2;
        if (!this.WEBINF.exists()) {
            throw new RuntimeException("The specified WEB-INF does not exist: " + this.WEBINF.getAbsolutePath());
        }
    }

    private void processMappings(String string) {
        HashSet<File> hashSet = new HashSet<File>();
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            File file;
            String[] stringArray2 = stringArray[n].split("=");
            if (stringArray2.length == 1) {
                file = new File(stringArray[n].trim());
                hashSet.add(file);
            } else {
                String string2 = stringArray2[0].trim();
                string2 = string2.startsWith("/") ? string2 : "/" + string2;
                string2 = string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2;
                file = new File(stringArray2[1].trim());
                this.aliasMap.put(string2, file);
            }
            if (!file.exists()) {
                log.error("Does not exist, cannot serve content: " + file.getAbsolutePath());
            } else {
                log.info("Serving content from " + file.getAbsolutePath());
            }
            ++n;
        }
        this.cfmlDirsFiles = hashSet.toArray(new File[hashSet.size()]);
    }

    @Override
    public Resource getResource(String string) {
        File file = null;
        try {
            if (this.WEBINF != null && (string.startsWith("/WEB-INF") || string.startsWith("./WEB-INF"))) {
                if (string.equals("/WEB-INF") || string.equals("./WEB-INF")) {
                    file = this.WEBINF;
                }
                file = new File(this.WEBINF, string.replaceAll(".+WEB-INF", ""));
            } else if (string.startsWith(this.WEBINF.getPath())) {
                file = new File(this.WEBINF, string.replace(this.WEBINF.getPath(), ""));
            } else if (string.startsWith("/CFIDE")) {
                file = new File(this.WEBINF.getParentFile(), string);
            } else if (!string.startsWith("/WEB-INF")) {
                file = new File(this.getBase(), string);
                if (!file.exists()) {
                    file = MappedResourceManager.getAliasedFile(this.aliasMap, string);
                }
                if (file != null) {
                    int n = 0;
                    while (n < this.cfmlDirsFiles.length) {
                        String string2 = this.cfmlDirsFiles[n].getCanonicalPath();
                        file = new File(this.cfmlDirsFiles[n], string.replace(string2, ""));
                        if (file.exists()) break;
                        ++n;
                    }
                }
            }
            if (file != null && file.exists()) {
                return new FileResource(file, this, string);
            }
            return super.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            log.error(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static File getAliasedFile(HashMap<String, File> var0, String var1_1) {
        var2_2 = var1_1.startsWith("/") != false ? var1_1 : "/" + var1_1;
        var3_3 = var0.get(var2_2);
        if (var3_3 == null) ** GOTO lbl10
        return new File(var3_3.getPath());
lbl-1000:
        // 1 sources

        {
            if (!var0.containsKey(var2_2 = var2_2.substring(0, var2_2.lastIndexOf(47)))) continue;
            var3_3 = new File(var0.get(var2_2), var1_1.replace(var2_2, ""));
            if (var3_3.getPath().indexOf(92) > 0) {
                var3_3 = new File(var3_3.getPath().replace('/', '\\'));
            }
            return var3_3;
lbl10:
            // 2 sources

            ** while (var2_2.lastIndexOf((int)47) > 0)
        }
lbl11:
        // 1 sources

        return null;
    }

    public HashMap<String, File> getAliasMap() {
        return this.aliasMap;
    }
}

