/*
 * Decompiled with CFR 0.152.
 */
package runwar.undertow;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletInfo;
import java.io.File;
import java.util.HashMap;
import javax.servlet.DispatcherType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import runwar.logging.Logger;

public class WebXMLParser {
    private static Logger log = Logger.getLogger("RunwarLogger");

    public static void parseWebXml(File file, DeploymentInfo deploymentInfo) {
        if (!file.exists() || !file.canRead()) {
            log.error("Error reading web.xml! exists:" + file.exists() + "readable:" + file.canRead());
        }
        try {
            String string;
            NodeList nodeList;
            Element element;
            NodeList nodeList2;
            String string2;
            NodeList nodeList3;
            Element element2;
            Object object;
            Object object2;
            Object object3;
            int n;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Node node;
            Node node2;
            String string3 = file.getParentFile().getCanonicalPath();
            if (File.separatorChar == '\\') {
                string3 = string3.replace("\\", "\\\\");
            }
            WebXMLParser.trace("parsing %s", file.getCanonicalPath());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            WebXMLParser.trace("Root element of the doc is %s", document.getDocumentElement().getNodeName());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            NodeList nodeList4 = document.getElementsByTagName("context-param");
            int n2 = nodeList4.getLength();
            WebXMLParser.trace("Total no of context-params: %s", n2);
            int n3 = 0;
            while (n3 < n2) {
                node2 = nodeList4.item(n3);
                if (node2.getNodeType() == 1) {
                    node = (Element)node2;
                    object13 = node.getElementsByTagName("param-name");
                    object12 = (Element)object13.item(0);
                    object11 = object12.getChildNodes();
                    object10 = object11.item(0).getNodeValue().trim();
                    WebXMLParser.trace("context param name: %s", object10);
                    object9 = node.getElementsByTagName("param-value");
                    object8 = (Element)object9.item(0);
                    object7 = object8.getChildNodes();
                    object6 = object7.item(0).getNodeValue().trim();
                    WebXMLParser.trace("context param value: %s", object6);
                    deploymentInfo.addServletContextAttribute((String)object10, object6);
                    deploymentInfo.addInitParameter((String)object10, (String)object6);
                }
                ++n3;
            }
            nodeList4 = document.getElementsByTagName("listener");
            n2 = nodeList4.getLength();
            WebXMLParser.trace("Total no of listeners: %s", n2);
            n3 = 0;
            while (n3 < n2) {
                node2 = nodeList4.item(n3);
                if (node2.getNodeType() == 1) {
                    node = (Element)node2;
                    object13 = node.getElementsByTagName("listener-class");
                    object12 = (Element)object13.item(0);
                    object11 = object12.getChildNodes();
                    object10 = object11.item(0).getNodeValue().trim();
                    WebXMLParser.trace("Param name: %s", object10);
                    object9 = new ListenerInfo(deploymentInfo.getClassLoader().loadClass((String)object10));
                    deploymentInfo.addListener((ListenerInfo)object9);
                }
                ++n3;
            }
            nodeList4 = document.getElementsByTagName("filter");
            n2 = nodeList4.getLength();
            WebXMLParser.trace("Total no of filters: %s", n2);
            n3 = 0;
            while (n3 < n2) {
                node2 = nodeList4.item(n3);
                if (node2.getNodeType() == 1) {
                    node = (Element)node2;
                    object13 = node.getElementsByTagName("filter-name");
                    object12 = (Element)object13.item(0);
                    object11 = object12.getChildNodes();
                    object10 = object11.item(0).getNodeValue().trim();
                    WebXMLParser.trace("Filter name: %s", object10);
                    object9 = node.getElementsByTagName("filter-class");
                    object8 = (Element)object9.item(0);
                    object7 = object8.getChildNodes();
                    object6 = object7.item(0).getNodeValue().trim();
                    WebXMLParser.trace("Filter class: %s", object6);
                    object5 = new FilterInfo((String)object10, deploymentInfo.getClassLoader().loadClass((String)object6));
                    object4 = node.getElementsByTagName("init-param");
                    n = object4.getLength();
                    WebXMLParser.trace("Total no of init-params: %s", n);
                    int n4 = 0;
                    while (n4 < n) {
                        object3 = object4.item(n4);
                        if (object3.getNodeType() == 1) {
                            object2 = (Element)object3;
                            object = object2.getElementsByTagName("param-name");
                            element2 = (Element)object.item(0);
                            nodeList3 = element2.getChildNodes();
                            string2 = nodeList3.item(0).getNodeValue().trim();
                            WebXMLParser.trace("Param name: %s", string2);
                            nodeList2 = object2.getElementsByTagName("param-value");
                            element = (Element)nodeList2.item(0);
                            nodeList = element.getChildNodes();
                            string = nodeList.item(0).getNodeValue().trim();
                            WebXMLParser.trace("Param value: %s", string);
                            ((FilterInfo)object5).addInitParam(string2, string);
                        }
                        ++n4;
                    }
                    NodeList nodeList5 = node.getElementsByTagName("async-supported");
                    if (nodeList5 != null && nodeList5.getLength() > 0) {
                        object3 = (Element)nodeList5.item(0);
                        object2 = object3.getChildNodes();
                        object = object2.item(0).getNodeValue().trim();
                        WebXMLParser.trace("Async supported: %s", object);
                        ((FilterInfo)object5).setAsyncSupported(Boolean.valueOf((String)object));
                    }
                    hashMap2.put(object10, object5);
                }
                deploymentInfo.addFilters(hashMap2.values());
                ++n3;
            }
            if (!hashMap2.isEmpty()) {
                nodeList4 = document.getElementsByTagName("filter-mapping");
                n2 = nodeList4.getLength();
                WebXMLParser.trace("Total no of filter-mappings: %s", n2);
                n3 = 0;
                while (n3 < n2) {
                    node2 = nodeList4.item(n3);
                    if (node2.getNodeType() == 1) {
                        node = (Element)node2;
                        object13 = node.getElementsByTagName("filter-name");
                        object12 = (Element)object13.item(0);
                        object11 = object12.getChildNodes();
                        object10 = object11.item(0).getNodeValue().trim();
                        WebXMLParser.trace("Param name: %s", object10);
                        object9 = (FilterInfo)hashMap2.get(object10);
                        if (object9 != null) {
                            object8 = node.getElementsByTagName("url-pattern");
                            if (object8 != null && object8.item(0) != null) {
                                object7 = (Element)object8.item(0);
                                object6 = object7.getChildNodes();
                                object5 = object6.item(0).getNodeValue().trim();
                                object4 = node.getElementsByTagName("dispatcher");
                                if (object4 == null || object4.getLength() == 0) {
                                    WebXMLParser.trace("Request FilterURL Mapping: " + (String)object10 + " is %s", object5);
                                    deploymentInfo.addFilterUrlMapping((String)object10, (String)object5, DispatcherType.valueOf("REQUEST"));
                                } else {
                                    n = object4.getLength();
                                    int n5 = 0;
                                    while (n5 < n) {
                                        object3 = (Element)object4.item(n5);
                                        object2 = object3.getChildNodes();
                                        object = object2.item(0).getNodeValue().trim();
                                        deploymentInfo.addFilterUrlMapping((String)object10, (String)object5, DispatcherType.valueOf((String)object));
                                        WebXMLParser.trace("FilterURL: %s", object10);
                                        WebXMLParser.trace("FilterURL: %s", object5);
                                        ++n5;
                                    }
                                }
                            }
                            if ((object8 = node.getElementsByTagName("servlet-name")) != null && object8.item(0) != null) {
                                object7 = (Element)object8.item(0);
                                object6 = object7.getChildNodes();
                                object5 = object6.item(0).getNodeValue().trim();
                                deploymentInfo.addFilterServletNameMapping((String)object10, (String)object5, DispatcherType.valueOf("REQUEST"));
                                WebXMLParser.trace("Filter Servlet: " + (String)object10 + " for %s", object5);
                            }
                        } else {
                            log.warnf("No servlet found for %s", object10);
                        }
                    }
                    ++n3;
                }
            }
            NodeList nodeList6 = document.getElementsByTagName("servlet");
            n2 = nodeList6.getLength();
            WebXMLParser.trace("Total no of servlets: %s", n2);
            int n6 = 0;
            while (n6 < nodeList6.getLength()) {
                node = nodeList6.item(n6);
                if (node.getNodeType() == 1) {
                    Element element3;
                    object13 = (Element)node;
                    object12 = object13.getElementsByTagName("servlet-name");
                    object11 = (Element)object12.item(0);
                    object10 = object11.getChildNodes();
                    object9 = object10.item(0).getNodeValue().trim();
                    WebXMLParser.trace("Adding servlet to undertow: ************* %s *************", object9);
                    WebXMLParser.trace("Param name: %s", object9);
                    object8 = object13.getElementsByTagName("servlet-class");
                    object7 = (Element)object8.item(0);
                    object6 = object7.getChildNodes();
                    object5 = object6.item(0).getNodeValue().trim();
                    WebXMLParser.trace("Param value: %s", object5);
                    object4 = new ServletInfo((String)object9, deploymentInfo.getClassLoader().loadClass((String)object5));
                    NodeList nodeList7 = object13.getElementsByTagName("load-on-startup");
                    if (nodeList7 != null && (element3 = (Element)nodeList7.item(0)) != null) {
                        object3 = element3.getChildNodes();
                        object2 = object3.item(0).getNodeValue().trim();
                        WebXMLParser.trace("Load on startup: %s", object2);
                        ((ServletInfo)object4).setLoadOnStartup(Integer.valueOf((String)object2));
                    }
                    ((ServletInfo)object4).setRequireWelcomeFileMapping(true);
                    nodeList4 = object13.getElementsByTagName("init-param");
                    n2 = nodeList4.getLength();
                    WebXMLParser.trace("Total no of init-params: %s", n2);
                    int n7 = 0;
                    while (n7 < n2) {
                        object3 = nodeList4.item(n7);
                        if (object3.getNodeType() == 1) {
                            object2 = (Element)object3;
                            object = object2.getElementsByTagName("param-name");
                            element2 = (Element)object.item(0);
                            nodeList3 = element2.getChildNodes();
                            string2 = nodeList3.item(0).getNodeValue().trim();
                            WebXMLParser.trace("Param name: %s", string2);
                            nodeList2 = object2.getElementsByTagName("param-value");
                            element = (Element)nodeList2.item(0);
                            nodeList = element.getChildNodes();
                            string = nodeList.item(0).getNodeValue().trim();
                            string = string.replaceAll(".?/WEB-INF", string3);
                            WebXMLParser.trace("Param value: %s", string);
                            ((ServletInfo)object4).addInitParam(string2, string);
                        }
                        ++n7;
                    }
                    hashMap.put(((ServletInfo)object4).getName(), object4);
                }
                ++n6;
            }
            if (!hashMap.isEmpty()) {
                nodeList4 = document.getElementsByTagName("servlet-mapping");
                n2 = nodeList4.getLength();
                log.warnf("Total no of servlet-mappings: %2", n2);
                n6 = 0;
                while (n6 < n2) {
                    node = nodeList4.item(n6);
                    if (node.getNodeType() == 1) {
                        object13 = (Element)node;
                        object12 = object13.getElementsByTagName("servlet-name");
                        object11 = (Element)object12.item(0);
                        object10 = object11.getChildNodes();
                        object9 = object10.item(0).getNodeValue().trim();
                        WebXMLParser.trace("Param name: %s", object9);
                        object8 = (ServletInfo)hashMap.get(object9);
                        if (object8 != null) {
                            object7 = object13.getElementsByTagName("url-pattern");
                            int n8 = 0;
                            while (n8 < object7.getLength()) {
                                object5 = (Element)object7.item(n8);
                                object4 = object5.getChildNodes();
                                String string4 = object4.item(0).getNodeValue().trim();
                                WebXMLParser.trace("Param value: %s", string4);
                                ((ServletInfo)object8).addMapping(string4);
                                ++n8;
                            }
                        } else {
                            log.warnf("No servlet found for %s", object9);
                        }
                    }
                    ++n6;
                }
                deploymentInfo.addServlets(hashMap.values());
            }
            nodeList4 = document.getElementsByTagName("welcome-file-list");
            n2 = nodeList4.getLength();
            WebXMLParser.trace("Total no of welcome-files: %s", n2);
            n6 = 0;
            while (n6 < n2) {
                node = nodeList4.item(n6);
                if (node.getNodeType() == 1) {
                    object13 = (Element)node;
                    object12 = object13.getElementsByTagName("welcome-file");
                    int n9 = object12.getLength();
                    log.debug("Adding welcome pages:");
                    int n10 = 0;
                    while (n10 < n9) {
                        object9 = (Element)object12.item(n10);
                        object8 = object9.getChildNodes();
                        object7 = object8.item(0).getNodeValue().trim();
                        WebXMLParser.trace("Param name: %s", object7);
                        log.debug("welcome page:" + (String)object7);
                        deploymentInfo.addWelcomePage((String)object7);
                        ++n10;
                    }
                }
                ++n6;
            }
            nodeList4 = document.getElementsByTagName("mime-mapping");
            n2 = nodeList4.getLength();
            log.debugf("Total no of mime-mapping: %s", n2);
            n6 = 0;
            while (n6 < n2) {
                node = nodeList4.item(n6);
                if (node.getNodeType() == 1) {
                    object13 = (Element)node;
                    object12 = object13.getElementsByTagName("extension");
                    Element element4 = (Element)object12.item(0);
                    NodeList nodeList8 = element4.getChildNodes();
                    object9 = nodeList8.item(0).getNodeValue().trim();
                    object8 = object13.getElementsByTagName("mime-type");
                    object7 = (Element)object8.item(0);
                    NodeList nodeList9 = object7.getChildNodes();
                    object5 = nodeList9.item(0).getNodeValue().trim();
                    log.debug("extension: " + (String)object9 + " mime-type: " + (String)object5);
                    deploymentInfo.addMimeMapping(new MimeMapping((String)object9, (String)object5));
                }
                ++n6;
            }
            NodeList nodeList10 = document.getElementsByTagName("display-name");
            if (nodeList10.getLength() == 1 && (node = nodeList10.item(0)).getNodeType() == 3) {
                object13 = node.getNodeValue().trim();
                WebXMLParser.trace("Display name: %s", object13);
                deploymentInfo.setDisplayName((String)object13);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("Error reading web.xml", exception);
        }
    }

    private static void trace(String string, Object object) {
        log.tracef(string, object);
    }
}

