/*
 * Decompiled with CFR 0.152.
 */
package runwar.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PausableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public boolean isPaused;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition unpaused = this.pauseLock.newCondition();
    private Latch activeTasksLatch = new Latch();

    public PausableScheduledThreadPoolExecutor(int n) {
        super(n);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        block6: {
            this.pauseLock.lock();
            try {
                try {
                    while (this.isPaused) {
                        this.unpaused.await();
                    }
                }
                catch (InterruptedException interruptedException) {
                    thread.interrupt();
                    this.pauseLock.unlock();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.pauseLock.unlock();
                throw throwable;
            }
            this.pauseLock.unlock();
        }
        this.activeTasksLatch.countUp();
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        try {
            super.afterExecute(runnable, throwable);
        }
        finally {
            this.activeTasksLatch.countDown();
        }
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public boolean await(long l) {
        try {
            return this.activeTasksLatch.awaitZero(l);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private class Latch {
        private final Object synchObj = new Object();
        private int count;

        private Latch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean awaitZero(long l) throws InterruptedException {
            long l2 = System.currentTimeMillis();
            Object object = this.synchObj;
            synchronized (object) {
                while (this.count > 0) {
                    if (l != 0L) {
                        this.synchObj.wait(l);
                        long l3 = System.currentTimeMillis();
                        if (l3 - l2 <= l) continue;
                        return this.count <= 0;
                    }
                    this.synchObj.wait();
                }
                return this.count <= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void countDown() {
            Object object = this.synchObj;
            synchronized (object) {
                if (--this.count <= 0) {
                    this.synchObj.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void countUp() {
            Object object = this.synchObj;
            synchronized (object) {
                ++this.count;
            }
        }
    }
}

