/*
 * Decompiled with CFR 0.152.
 */
package runwar.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Reflection {
    public static Class<?> load(ClassLoader classLoader, String string) {
        try {
            return classLoader.loadClass(string);
        }
        catch (Exception exception) {
            Reflection.handleReflectionException(exception);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Method method(Class<?> clazz, String string) {
        return Reflection.method(clazz, string, new Class[0]);
    }

    public static Method method(Class<?> clazz, String string, Class<?> ... classArray) {
        Class<?> clazz2 = clazz;
        while (!Object.class.equals(clazz2) && clazz2 != null) {
            Method[] methodArray = clazz2.isInterface() ? clazz2.getMethods() : clazz2.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (string.equals(method.getName()) && Arrays.equals(classArray, method.getParameterTypes())) {
                    return method;
                }
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public static Object invoke(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Reflection.handleReflectionException(exception);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void handleReflectionException(Exception exception) {
        if (exception instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + exception.getMessage());
        }
        if (exception instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + exception.getMessage());
        }
        if (exception instanceof InvocationTargetException) {
            Reflection.handleInvocationTargetException((InvocationTargetException)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Reflection.handleUnexpectedException(exception);
    }

    public static void rethrowRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        Reflection.handleUnexpectedException(throwable);
    }

    public static void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        Reflection.rethrowRuntimeException(invocationTargetException.getTargetException());
    }

    private static void handleUnexpectedException(Throwable throwable) {
        IllegalStateException illegalStateException = new IllegalStateException("Unexpected exception thrown");
        illegalStateException.initCause(throwable);
        throw illegalStateException;
    }
}

