/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class HotSpotVirtualMachine
extends VirtualMachine {
    private static final int JNI_ENOMEM = -4;
    private static final int ATTACH_ERROR_BADJAR = 100;
    private static final int ATTACH_ERROR_NOTONCP = 101;
    private static final int ATTACH_ERROR_STARTFAIL = 102;
    private static long defaultAttachTimeout = 5000L;
    private volatile long attachTimeout;

    HotSpotVirtualMachine(AttachProvider attachProvider, String string) {
        super(attachProvider, string);
    }

    private void loadAgentLibrary(String string, boolean bl, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        try (InputStream inputStream = this.execute("load", string, bl ? "true" : "false", string2);){
            int n = this.readInt(inputStream);
            if (n != 0) {
                throw new AgentInitializationException("Agent_OnAttach failed", n);
            }
        }
    }

    @Override
    public void loadAgentLibrary(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(string, false, string2);
    }

    @Override
    public void loadAgentPath(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(string, true, string2);
    }

    @Override
    public void loadAgent(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        String string3 = string;
        if (string2 != null) {
            string3 = String.valueOf(string3) + "=" + string2;
        }
        try {
            this.loadAgentLibrary("instrument", string3);
        }
        catch (AgentLoadException agentLoadException) {
            throw new InternalError("instrument library is missing in target VM");
        }
        catch (AgentInitializationException agentInitializationException) {
            int n = agentInitializationException.returnValue();
            switch (n) {
                case -4: {
                    throw new AgentLoadException("Insuffient memory");
                }
                case 100: {
                    throw new AgentLoadException("Agent JAR not found or no Agent-Class attribute");
                }
                case 101: {
                    throw new AgentLoadException("Unable to add JAR file to system class path");
                }
                case 102: {
                    throw new AgentInitializationException("Agent JAR loaded but agent failed to initialize");
                }
            }
            throw new AgentLoadException("Failed to load agent - unknown reason: " + n);
        }
    }

    @Override
    public Properties getSystemProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = null;){
            inputStream = this.executeCommand("properties", new Object[0]);
            properties.load(inputStream);
        }
        return properties;
    }

    @Override
    public Properties getAgentProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = null;){
            inputStream = this.executeCommand("agentProperties", new Object[0]);
            properties.load(inputStream);
        }
        return properties;
    }

    public void localDataDump() throws IOException {
        this.executeCommand("datadump", new Object[0]).close();
    }

    public InputStream remoteDataDump(Object ... objectArray) throws IOException {
        return this.executeCommand("threaddump", objectArray);
    }

    public InputStream dumpHeap(Object ... objectArray) throws IOException {
        return this.executeCommand("dumpheap", objectArray);
    }

    public InputStream heapHisto(Object ... objectArray) throws IOException {
        return this.executeCommand("inspectheap", objectArray);
    }

    public InputStream setFlag(String string, String string2) throws IOException {
        return this.executeCommand("setflag", string, string2);
    }

    public InputStream printFlag(String string) throws IOException {
        return this.executeCommand("printflag", string);
    }

    public InputStream executeJCmd(String string) throws IOException {
        return this.executeCommand("jcmd", string);
    }

    abstract InputStream execute(String var1, Object ... var2) throws AgentLoadException, IOException;

    private InputStream executeCommand(String string, Object ... objectArray) throws IOException {
        try {
            return this.execute(string, objectArray);
        }
        catch (AgentLoadException agentLoadException) {
            throw new InternalError("Should not get here");
        }
    }

    int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[1];
        do {
            if ((n2 = inputStream.read(byArray, 0, 1)) <= 0) continue;
            n = byArray[0];
            if (n == 10) break;
            stringBuilder.append((char)n);
        } while (n2 > 0);
        if (stringBuilder.length() == 0) {
            throw new IOException("Premature EOF");
        }
        try {
            n = Integer.parseInt(stringBuilder.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Non-numeric value found - int expected");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long attachTimeout() {
        if (this.attachTimeout == 0L) {
            HotSpotVirtualMachine hotSpotVirtualMachine = this;
            synchronized (hotSpotVirtualMachine) {
                if (this.attachTimeout == 0L) {
                    try {
                        String string = System.getProperty("sun.tools.attach.attachTimeout");
                        this.attachTimeout = Long.parseLong(string);
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (this.attachTimeout <= 0L) {
                        this.attachTimeout = defaultAttachTimeout;
                    }
                }
            }
        }
        return this.attachTimeout;
    }
}

