/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sun.tools.attach.HotSpotVirtualMachine;

public class SolarisVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir = "/tmp";
    private int fd = -1;

    static {
        System.loadLibrary("attach");
    }

    public SolarisVirtualMachine(AttachProvider attachProvider, String string) throws AttachNotSupportedException, IOException {
        super(attachProvider, string);
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AttachNotSupportedException("invalid process identifier");
        }
        try {
            this.fd = this.openDoor(n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = this.createAttachFile(n);
            try {
                SolarisVirtualMachine.sigquit(n);
                int n2 = 0;
                long l = 200L;
                int n3 = (int)(this.attachTimeout() / l);
                do {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        this.fd = this.openDoor(n);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {}
                } while (++n2 <= n3 && this.fd == -1);
                if (this.fd == -1) {
                    throw new AttachNotSupportedException("Unable to open door: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                file.delete();
            }
            {
            }
        }
        assert (this.fd >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd != -1) {
                SolarisVirtualMachine.close(this.fd);
                this.fd = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String string, Object ... objectArray) throws AgentLoadException, IOException {
        int n;
        int n2;
        assert (objectArray.length <= 3);
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd == -1) {
                throw new IOException("Detached from target VM");
            }
            n2 = this.fd;
        }
        int n3 = SolarisVirtualMachine.enqueue(n2, string, objectArray);
        assert (n3 >= 0);
        SocketInputStream socketInputStream = new SocketInputStream(n3);
        try {
            n = this.readInt(socketInputStream);
        }
        catch (IOException iOException) {
            socketInputStream.close();
            throw iOException;
        }
        if (n != 0) {
            socketInputStream.close();
            if (string.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            throw new IOException("Command failed in target VM");
        }
        return socketInputStream;
    }

    private int openDoor(int n) throws IOException {
        String string = "/tmp/.java_pid" + n;
        this.fd = SolarisVirtualMachine.open(string);
        try {
            SolarisVirtualMachine.checkPermissions(string);
        }
        catch (IOException iOException) {
            SolarisVirtualMachine.close(this.fd);
            throw iOException;
        }
        return this.fd;
    }

    private File createAttachFile(int n) throws IOException {
        String string = ".attach_pid" + n;
        String string2 = "/proc/" + n + "/cwd/" + string;
        File file = new File(string2);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            file = new File(tmpdir, string);
            file.createNewFile();
        }
        return file;
    }

    static native int open(String var0) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native void sigquit(int var0) throws IOException;

    static native int enqueue(int var0, String var1, Object ... var2) throws IOException;

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int n) {
            this.s = n;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            return SolarisVirtualMachine.read(this.s, byArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            SolarisVirtualMachine.close(this.s);
        }
    }
}

