/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;
import org.cheffo.jeplite.ASTVarNode;
import org.cheffo.jeplite.ParseException;
import org.cheffo.jeplite.Parser;
import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.function.PostfixMathCommand;
import org.cheffo.jeplite.util.DoubleStack;

public class JEP {
    private HashMap symTab;
    private HashMap funTab;
    private SimpleNode topNode = null;
    private boolean debug = false;
    private Parser parser;
    private boolean hasError = true;
    private ParseException parseException = null;

    public JEP() {
        this.initSymTab();
        this.initFunTab();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void initSymTab() {
        this.symTab = new HashMap();
    }

    public void initFunTab() {
        this.funTab = new HashMap();
    }

    public void addStandardFunctions() {
        PostfixMathCommand.fillFunctionTable(this.funTab);
    }

    public void addStandardConstants() {
        this.addVariable("pi", Math.PI);
        this.addVariable("e", Math.E);
    }

    public void addFunction(String functionName, Object function) {
        this.funTab.put(functionName, function);
    }

    public Double addVariable(String name, double value) {
        ASTVarNode toAdd = (ASTVarNode)this.symTab.get(name);
        if (toAdd != null) {
            toAdd.setValue(value);
        } else {
            toAdd = new ASTVarNode(3);
            toAdd.setName(name);
            toAdd.setValue(value);
            this.symTab.put(name, toAdd);
        }
        return new Double(value);
    }

    public ASTVarNode getVarNode(String var) {
        return (ASTVarNode)this.symTab.get(var);
    }

    public void setVarNode(String var, ASTVarNode node) {
        this.symTab.put(var, node);
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        this.hasError = false;
        this.parseException = null;
        try {
            this.topNode = this.parser.parseStream(reader, this.symTab, this.funTab);
        }
        catch (Throwable e) {
            if (this.debug && !(e instanceof ParseException)) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            this.topNode = null;
            this.hasError = true;
            this.parseException = e instanceof ParseException ? (ParseException)e : null;
        }
        Vector errorList = this.parser.getErrorList();
        if (!errorList.isEmpty()) {
            this.hasError = true;
        }
    }

    public double getValue() throws ParseException {
        return this.getValue(new DoubleStack());
    }

    public SimpleNode getTopNode() {
        return this.topNode;
    }

    public double getValue(DoubleStack evalStack) throws ParseException {
        this.topNode.getValue(evalStack);
        return evalStack.pop();
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorInfo() {
        if (this.hasError) {
            Vector el = this.parser.getErrorList();
            String str = "";
            if (this.parseException == null && el.size() == 0) {
                str = "Syntax error\n";
            }
            if (this.parseException != null) {
                str = String.valueOf(String.valueOf(this.parseException.getErrorInfo())).concat("\n");
            }
            for (int i = 0; i < el.size(); ++i) {
                str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(el.elementAt(i))).concat("\n"))));
            }
            return str;
        }
        return null;
    }
}

