/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.HashMap;
import org.cheffo.jeplite.JEP;
import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.optimizer.ExpressionOptimizer;
import org.cheffo.jeplite.util.DoubleStack;

public class Tests {
    static JEP jep = new JEP();
    static HashMap params = new HashMap();

    static void parseParams(String[] args) {
        for (int i = 0; i < args.length; i += 2) {
            params.put(args[i].toLowerCase().trim(), args[i + 1]);
        }
    }

    static void doIt(String toParse, BufferedWriter fw, SimpleNode optNode) throws Exception {
        int j;
        long[] testArray = new long[10];
        double d = 0.0;
        DoubleStack stack = new DoubleStack();
        for (j = 0; j < 10; ++j) {
            Thread.yield();
            long start = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                d = optNode.getValue();
            }
            testArray[j] = System.currentTimeMillis() - start;
        }
        fw.write("100000 evaluations: ");
        for (j = 0; j < 10; ++j) {
            fw.write(String.valueOf(String.valueOf(testArray[j])).concat(", "));
        }
        fw.write("\n");
    }

    public static void main(String[] args) throws Exception {
        Date startTime = new Date();
        Tests.parseParams(args);
        File inFile = new File((String)params.get("-file"));
        File logFile = new File((String)params.get("-logfile"));
        BufferedReader fr = new BufferedReader(new FileReader(inFile));
        BufferedWriter fw = new BufferedWriter(new FileWriter(logFile));
        jep.addStandardConstants();
        jep.addStandardFunctions();
        String curLine = null;
        boolean lines = false;
        while ((curLine = fr.readLine()) != null) {
            int j;
            if (curLine.startsWith("#")) continue;
            String description = curLine;
            String toParse = fr.readLine();
            double result = Double.parseDouble(fr.readLine().trim());
            fw.write(String.valueOf(String.valueOf(new StringBuffer("Processing:").append(toParse).append(",\n"))));
            fw.write(String.valueOf(String.valueOf(new StringBuffer("Expected: ").append(result).append("\n"))));
            fw.flush();
            double d = 0.0;
            DoubleStack stack = new DoubleStack();
            for (int i = 0; i < 1000; ++i) {
                jep.parseExpression(toParse);
                d = jep.getValue(stack);
            }
            SimpleNode optNode = jep.getTopNode();
            fw.write("Not Optimized: ");
            Tests.doIt(toParse, fw, optNode);
            ExpressionOptimizer optimizer = new ExpressionOptimizer(jep.getTopNode());
            optNode = optimizer.optimize();
            fw.write("Optimized    : ");
            Tests.doIt(toParse, fw, optNode);
            long[] testArray = new long[10];
            for (j = 0; j < 10; ++j) {
                Thread.yield();
                long start = System.currentTimeMillis();
                for (int i = 0; i < 1000; ++i) {
                    jep.parseExpression(toParse);
                }
                testArray[j] = System.currentTimeMillis() - start;
            }
            fw.write("1000 parses: ");
            for (j = 0; j < 10; ++j) {
                fw.write(String.valueOf(String.valueOf(testArray[j])).concat(", "));
            }
            fw.write("\n");
            fw.write(String.valueOf(String.valueOf(d)).concat("\n_____________________________________________________\n"));
            fw.flush();
        }
        Date endTime = new Date();
        fw.write(String.valueOf(String.valueOf(new StringBuffer("Start time: ").append(startTime).append("\n"))));
        fw.write(String.valueOf(String.valueOf(new StringBuffer("End time: ").append(endTime).append("\n"))));
        fw.write(String.valueOf(String.valueOf(new StringBuffer("Total time: ").append(endTime.getTime() - startTime.getTime()).append(" ms"))));
        fw.close();
    }
}

