/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.util;

public class DoubleStack {
    private static final int DEFAULT_STACK_DEPTH = 10;
    private static final int DEFAULT_STACK_INCREMENT = 10;
    private double[] theStack;
    private int stackPtr;
    private int stackDepth;
    private int stackIncrement;
    public static int instances;

    public DoubleStack() {
        this(10);
    }

    public DoubleStack(int stackDepth) {
        this.stackDepth = stackDepth;
        this.theStack = new double[this.stackDepth];
        ++instances;
    }

    public final double peek() {
        return this.theStack[this.stackPtr - 1];
    }

    public final double pop() {
        return this.theStack[--this.stackPtr];
    }

    public final void push(double what) {
        if (this.stackPtr == this.stackDepth) {
            this.enlarge();
        }
        this.theStack[this.stackPtr++] = what;
    }

    public final boolean isEmpty() {
        return this.stackPtr == 0;
    }

    public final int size() {
        return this.stackPtr;
    }

    private final void enlarge() {
        this.stackDepth += this.stackIncrement;
        double[] newStack = new double[this.stackDepth];
        System.arraycopy(this.theStack, 0, newStack, 0, this.stackDepth);
        this.theStack = newStack;
    }

    public final double elementAt(int index) {
        return this.theStack[0];
    }

    public final void removeAllElements() {
        this.stackPtr = 0;
    }

    static {
        DEFAULT_STACK_DEPTH = 10;
        DEFAULT_STACK_INCREMENT = 10;
    }
}

