/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.AlwaysRetryStrategy;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.internal.CreateTableRequestEx;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.chenmin.open.objector.ColumnTypeObject;
import org.chenmin.open.objector.ColumnValueObject;
import org.chenmin.open.objector.Config;
import org.chenmin.open.objector.IStoreTable;
import org.chenmin.open.objector.IStoreTableRow;
import org.chenmin.open.objector.ITableStoreService;
import org.chenmin.open.objector.PrimaryKeySchemaObject;
import org.chenmin.open.objector.PrimaryKeyValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableStoreService
implements ITableStoreService {
    SyncClient client = null;

    public TableStoreService() {
        this.init();
    }

    public boolean exsit(IStoreTable table) {
        return this.exsit(table.getTablename());
    }

    public boolean exsit(String tablename) {
        DescribeTableRequest request = new DescribeTableRequest(tablename);
        try {
            DescribeTableResponse response = this.client.describeTable(request);
            TableMeta tableMeta = response.getTableMeta();
            if (tableMeta != null && tableMeta.getTableName() != null) {
                return true;
            }
        }
        catch (TableStoreException e) {
            return false;
        }
        catch (ClientException e) {
            return false;
        }
        return false;
    }

    public boolean createTable(IStoreTable table) {
        TableMeta tableMeta = new TableMeta(table.getTablename());
        List primaryKey = table.getPrimaryKey();
        block10: for (PrimaryKeySchemaObject k : primaryKey) {
            if (k.getOption() != null) {
                switch (k.getType()) {
                    case INTEGER: {
                        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.INTEGER, PrimaryKeyOption.AUTO_INCREMENT));
                        continue block10;
                    }
                    case STRING: {
                        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.STRING, PrimaryKeyOption.AUTO_INCREMENT));
                        continue block10;
                    }
                    case BINARY: {
                        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.BINARY, PrimaryKeyOption.AUTO_INCREMENT));
                        continue block10;
                    }
                }
                continue;
            }
            switch (k.getType()) {
                case INTEGER: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.INTEGER));
                    break;
                }
                case STRING: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.STRING));
                    break;
                }
                case BINARY: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(k.getName(), PrimaryKeyType.BINARY));
                    break;
                }
            }
        }
        int timeToLive = table.timeToLive();
        int maxVersions = table.maxVersions();
        int writeCapacityUnit = table.writeCapacityUnit();
        TableOptions tableOptions = new TableOptions(timeToLive, maxVersions);
        int readCapacityUnit = table.readCapacityUnit();
        CreateTableRequestEx request = new CreateTableRequestEx(tableMeta, tableOptions, new ReservedThroughput(new CapacityUnit(readCapacityUnit, writeCapacityUnit)));
        CreateTableResponse r = this.client.createTable((CreateTableRequest)request);
        return r.getRequestId() != null;
    }

    public boolean init() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setConnectionTimeoutInMillisecond(5000);
        clientConfiguration.setSocketTimeoutInMillisecond(5000);
        clientConfiguration.setRetryStrategy((RetryStrategy)new AlwaysRetryStrategy());
        this.client = new SyncClient(Config.get("TS_ENDPOINT"), Config.get("ALIYUN_ACCESS_KEY"), Config.get("ALIYUN_SECRET_KEY"), Config.get("TS_INSTANCENAME"), clientConfiguration);
        return false;
    }

    public boolean putRow(IStoreTableRow row) {
        return this.putRow(row.getTablename(), row.getPrimaryKeyValue(), row.getColumnValue());
    }

    public boolean putRow(String tablename, Map<String, PrimaryKeyValueObject> primaryKey, Map<String, ColumnValueObject> column) {
        PrimaryKey primaryKeys = this.buildKey(primaryKey);
        RowPutChange rowPutChange = new RowPutChange(tablename, primaryKeys);
        List<Column> list = this.covert(column);
        for (Column c : list) {
            rowPutChange.addColumn(c);
        }
        PutRowResponse r = this.client.putRow(new PutRowRequest(rowPutChange));
        return r.getRequestId() != null;
    }

    private List<Column> covert(Map<String, ColumnValueObject> column) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (String ck : column.keySet()) {
            ColumnValueObject cv = column.get(ck);
            if (cv.getValue() == null) continue;
            Column c = null;
            switch (cv.getType()) {
                case INTEGER: {
                    c = new Column(ck, ColumnValue.fromLong((long)((Long)cv.getValue())));
                    break;
                }
                case STRING: {
                    c = new Column(ck, ColumnValue.fromString((String)cv.getValue().toString()));
                    break;
                }
                case BOOLEAN: {
                    c = new Column(ck, ColumnValue.fromBoolean((boolean)((Boolean)cv.getValue())));
                    break;
                }
                case DOUBLE: {
                    c = new Column(ck, ColumnValue.fromDouble((double)((Double)cv.getValue())));
                    break;
                }
                case BINARY: {
                    c = new Column(ck, ColumnValue.fromBinary((byte[])((byte[])cv.getValue())));
                    break;
                }
            }
            if (c == null) continue;
            list.add(c);
        }
        return list;
    }

    private PrimaryKey buildKey(Map<String, PrimaryKeyValueObject> primaryKey) {
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        for (String pk : primaryKey.keySet()) {
            PrimaryKeyValueObject pkv = primaryKey.get(pk);
            switch (pkv.getType()) {
                case INTEGER: {
                    primaryKeyBuilder.addPrimaryKeyColumn(pk, PrimaryKeyValue.fromLong((long)((Long)pkv.getValue())));
                    break;
                }
                case STRING: {
                    primaryKeyBuilder.addPrimaryKeyColumn(pk, PrimaryKeyValue.fromString((String)((String)pkv.getValue())));
                    break;
                }
                case BINARY: {
                    primaryKeyBuilder.addPrimaryKeyColumn(pk, PrimaryKeyValue.fromBinary((byte[])((byte[])pkv.getValue())));
                    break;
                }
            }
        }
        PrimaryKey primaryKeys = primaryKeyBuilder.build();
        return primaryKeys;
    }

    public boolean getRow(IStoreTableRow row) {
        PrimaryKey primaryKeys = this.buildKey(row.getPrimaryKeyValue());
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(row.getTablename(), primaryKeys);
        criteria.setMaxVersions(1);
        GetRowResponse getRowResponse = this.client.getRow(new GetRowRequest(criteria));
        if (getRowResponse == null) {
            return false;
        }
        Row rows = getRowResponse.getRow();
        if (rows == null) {
            return false;
        }
        Column[] cols = rows.getColumns();
        LinkedHashMap<String, ColumnValueObject> v = new LinkedHashMap<String, ColumnValueObject>();
        for (Column c : cols) {
            ColumnValue cv = c.getValue();
            ColumnValueObject cvo = null;
            switch (cv.getType()) {
                case STRING: {
                    cvo = new ColumnValueObject((Object)cv.asString(), ColumnTypeObject.STRING);
                    break;
                }
                case INTEGER: {
                    cvo = new ColumnValueObject((Object)cv.asLong(), ColumnTypeObject.INTEGER);
                    break;
                }
                case BOOLEAN: {
                    cvo = new ColumnValueObject((Object)cv.asBoolean(), ColumnTypeObject.BOOLEAN);
                    break;
                }
                case DOUBLE: {
                    cvo = new ColumnValueObject((Object)cv.asDouble(), ColumnTypeObject.DOUBLE);
                    break;
                }
                case BINARY: {
                    cvo = new ColumnValueObject((Object)cv.asBinary(), ColumnTypeObject.BINARY);
                    break;
                }
            }
            v.put(c.getName(), cvo);
        }
        row.setColumnValue(v);
        return getRowResponse.getRequestId() != null;
    }

    public boolean deleteRow(IStoreTableRow row) {
        PrimaryKey primaryKeys = this.buildKey(row.getPrimaryKeyValue());
        RowDeleteChange rowDeleteChange = new RowDeleteChange(row.getTablename(), primaryKeys);
        DeleteRowResponse r = this.client.deleteRow(new DeleteRowRequest(rowDeleteChange));
        return r.getRequestId() != null;
    }

    public boolean updateRow(IStoreTableRow row) {
        PrimaryKey primaryKeys = this.buildKey(row.getPrimaryKeyValue());
        RowUpdateChange rowUpdateChange = new RowUpdateChange(row.getTablename(), primaryKeys);
        List<Column> list = this.covert(row.getColumnValue());
        for (Column c : list) {
            rowUpdateChange.put(c);
        }
        UpdateRowResponse r = this.client.updateRow(new UpdateRowRequest(rowUpdateChange));
        return r.getRequestId() != null;
    }

    public boolean deleteTable(IStoreTable table) {
        DeleteTableRequest request = new DeleteTableRequest(table.getTablename());
        DeleteTableResponse r = this.client.deleteTable(request);
        return r.getRequestId() != null;
    }
}

