/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.NavigableMap;
import org.apache.commons.beanutils.BeanUtils;
import org.chenmin.open.objector.ColumnValueObject;
import org.chenmin.open.objector.IStore;
import org.chenmin.open.objector.IStoreTable;
import org.chenmin.open.objector.IStoreTableRow;
import org.chenmin.open.objector.ITableStoreService;
import org.chenmin.open.objector.Objector;
import org.chenmin.open.objector.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store
implements IStore {
    protected Objector objector;
    protected ITableStoreService tableStoreService;

    public Objector getObjector() {
        return this.objector;
    }

    public void setObjector(Objector objector) {
        this.objector = objector;
    }

    public ITableStoreService getTableStoreService() {
        return this.tableStoreService;
    }

    public void setTableStoreService(ITableStoreService tableStoreService) {
        this.tableStoreService = tableStoreService;
    }

    protected Serializable createObject(Serializable t) {
        Serializable object = this.objector.createObject(t.getClass());
        return object;
    }

    protected Serializable copyObject(Serializable user) {
        try {
            Serializable userObject = this.createObject(user);
            BeanUtils.copyProperties((Object)userObject, (Object)user);
            return userObject;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean save(Serializable t) throws StoreException {
        return this.tableStoreService.putRow((IStoreTableRow)this.copyObject(t));
    }

    public boolean del(Serializable t) throws StoreException {
        return this.tableStoreService.deleteRow((IStoreTableRow)this.copyObject(t));
    }

    public boolean get(Serializable t) throws StoreException {
        IStoreTableRow copyObject = (IStoreTableRow)this.copyObject(t);
        boolean row = this.tableStoreService.getRow(copyObject);
        try {
            BeanUtils.copyProperties((Object)t, (Object)copyObject);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return row;
    }

    public boolean update(Serializable t) throws StoreException {
        return this.tableStoreService.updateRow((IStoreTableRow)this.copyObject(t));
    }

    public boolean exsitTable(Serializable t) throws StoreException {
        return this.tableStoreService.exsit((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean createTable(Serializable t) throws StoreException {
        return this.tableStoreService.createTable((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean deleteTable(Serializable t) throws StoreException {
        return this.tableStoreService.deleteTable((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean getByMaxVersions(Serializable t, int max, NavigableMap<String, NavigableMap<Long, ColumnValueObject>> columnMap) throws StoreException {
        return this.tableStoreService.getByMaxVersions((IStoreTableRow)this.copyObject(t), max, columnMap);
    }
}

