/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.IntrospectionContext;
import org.apache.commons.lang.WordUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanIntrospector
implements BeanIntrospector {
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            if (!m.getName().startsWith("is") || !Boolean.class.equals(m.getReturnType())) continue;
            String propertyName = this.getPropertyName(m);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            if (pd == null) {
                icontext.addPropertyDescriptor(new PropertyDescriptor(propertyName, m, this.getWriteMethod(icontext.getTargetClass(), propertyName)));
                continue;
            }
            if (pd.getReadMethod() != null) continue;
            pd.setReadMethod(m);
        }
    }

    private String getPropertyName(Method m) {
        return WordUtils.uncapitalize((String)m.getName().substring(2, m.getName().length()));
    }

    private Method getWriteMethod(Class<?> clazz, String propertyName) {
        try {
            return clazz.getMethod("get" + WordUtils.capitalize((String)propertyName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

