/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.chenmin.open.objector.BooleanIntrospector;
import org.chenmin.open.objector.ColumnValueObject;
import org.chenmin.open.objector.IStore;
import org.chenmin.open.objector.IStoreTable;
import org.chenmin.open.objector.IStoreTableRow;
import org.chenmin.open.objector.ITableStoreService;
import org.chenmin.open.objector.Objector;
import org.chenmin.open.objector.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store
implements IStore {
    protected Objector objector;
    protected ITableStoreService tableStoreService;

    public Objector getObjector() {
        return this.objector;
    }

    public void setObjector(Objector objector) {
        this.objector = objector;
    }

    public ITableStoreService getTableStoreService() {
        return this.tableStoreService;
    }

    public void setTableStoreService(ITableStoreService tableStoreService) {
        this.tableStoreService = tableStoreService;
    }

    protected Serializable createObject(Serializable t) {
        Serializable object = this.objector.createObject(t.getClass());
        return object;
    }

    protected Serializable copyObject(Serializable user) {
        try {
            Serializable userObject = this.createObject(user);
            BeanUtils.copyProperties((Object)userObject, (Object)user);
            return userObject;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean save(Serializable t) throws StoreException {
        IStoreTableRow copyObject = (IStoreTableRow)this.copyObject(t);
        boolean row = this.tableStoreService.putRow(copyObject);
        try {
            BeanUtils.copyProperties((Object)t, (Object)copyObject);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return row;
    }

    public boolean del(Serializable t) throws StoreException {
        return this.tableStoreService.deleteRow((IStoreTableRow)this.copyObject(t));
    }

    public boolean get(Serializable t) throws StoreException {
        IStoreTableRow copyObject = (IStoreTableRow)this.copyObject(t);
        boolean row = this.tableStoreService.getRow(copyObject);
        try {
            BeanUtils.copyProperties((Object)t, (Object)copyObject);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return row;
    }

    public boolean update(Serializable t) throws StoreException {
        return this.tableStoreService.updateRow((IStoreTableRow)this.copyObject(t));
    }

    public boolean exsitTable(Serializable t) throws StoreException {
        return this.tableStoreService.exsit((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean createTable(Serializable t) throws StoreException {
        return this.tableStoreService.createTable((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean deleteTable(Serializable t) throws StoreException {
        return this.tableStoreService.deleteTable((IStoreTable)((IStoreTableRow)this.copyObject(t)));
    }

    public boolean getByMaxVersions(Serializable t, int max, NavigableMap<String, NavigableMap<Long, ColumnValueObject>> columnMap) throws StoreException {
        return this.tableStoreService.getByMaxVersions((IStoreTableRow)this.copyObject(t), max, columnMap);
    }

    public boolean increment(Serializable t) throws StoreException {
        IStoreTableRow copyObject = (IStoreTableRow)this.copyObject(t);
        boolean row = this.tableStoreService.increment(copyObject);
        try {
            BeanUtils.copyProperties((Object)t, (Object)copyObject);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return row;
    }

    public <T extends Serializable> T getRange(Serializable start, Serializable end, List<? extends Serializable> range, boolean asc, int limit) throws StoreException {
        IStoreTableRow s = (IStoreTableRow)this.copyObject(start);
        IStoreTableRow e = (IStoreTableRow)this.copyObject(end);
        ArrayList r = new ArrayList();
        IStoreTableRow n = this.tableStoreService.getRange(s, e, r, asc, limit);
        Serializable next = null;
        if (n == null) {
            next = null;
        } else {
            try {
                next = (Serializable)start.getClass().newInstance();
                BeanUtils.copyProperties((Object)next, (Object)n);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
        }
        try {
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (IStoreTableRow rr : r) {
                Serializable r1 = (Serializable)start.getClass().newInstance();
                BeanUtils.copyProperties((Object)r1, (Object)rr);
                list.add(r1);
            }
            range.addAll(list);
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        return (T)next;
    }

    static {
        BooleanIntrospector a = new BooleanIntrospector();
        BeanUtilsBean.getInstance().getPropertyUtils().addBeanIntrospector((BeanIntrospector)a);
    }
}

