/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import org.chenmin.open.objector.PrimaryKeyTypeObject;

public class PrimaryKeyValueObject {
    private Object value;
    private byte[] rawData;
    private PrimaryKeyTypeObject type;

    public PrimaryKeyValueObject(Object value, PrimaryKeyTypeObject type) {
        this.value = value;
        this.type = type;
    }

    public static PrimaryKeyValueObject fromString(String value) {
        return new PrimaryKeyValueObject(value, PrimaryKeyTypeObject.STRING);
    }

    public static PrimaryKeyValueObject fromLong(Long value) {
        return new PrimaryKeyValueObject(value, PrimaryKeyTypeObject.INTEGER);
    }

    public static PrimaryKeyValueObject fromlong(long value) {
        return new PrimaryKeyValueObject(value, PrimaryKeyTypeObject.INTEGER);
    }

    public static PrimaryKeyValueObject fromInt(int value) {
        return new PrimaryKeyValueObject(value, PrimaryKeyTypeObject.INTEGER);
    }

    public static PrimaryKeyValueObject fromBinary(byte[] value) {
        return new PrimaryKeyValueObject(value, PrimaryKeyTypeObject.BINARY);
    }

    public Object getValue() {
        return this.value;
    }

    public String asString() {
        if (this.type != PrimaryKeyTypeObject.STRING) {
            throw new IllegalStateException("The type of primary key is not STRING.");
        }
        return (String)this.value;
    }

    public long aslong() {
        if (this.type != PrimaryKeyTypeObject.INTEGER) {
            throw new IllegalStateException("The type of primary key is not INTEGER.");
        }
        return (Long)this.value;
    }

    public Long asLong() {
        if (this.type != PrimaryKeyTypeObject.INTEGER) {
            throw new IllegalStateException("The type of primary key is not INTEGER.");
        }
        return (Long)this.value;
    }

    public int asInt() {
        if (this.type != PrimaryKeyTypeObject.INTEGER) {
            throw new IllegalStateException("The type of primary key is not INTEGER.");
        }
        return ((Long)this.value).intValue();
    }

    public byte[] asBinary() {
        if (this.type != PrimaryKeyTypeObject.BINARY) {
            throw new IllegalStateException("The type of primary key is not BINARY");
        }
        return (byte[])this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    public PrimaryKeyTypeObject getType() {
        return this.type;
    }

    public void setType(PrimaryKeyTypeObject type) {
        this.type = type;
    }
}

