/*
 * Decompiled with CFR 0.152.
 */
package org.chenmin.open.objector;

import org.chenmin.open.objector.ColumnTypeObject;

public class ColumnValueObject {
    private Object value;
    private byte[] rawData;
    private ColumnTypeObject type;

    public ColumnValueObject(Object value, ColumnTypeObject type) {
        this.value = value;
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public String asString() {
        if (this.type != ColumnTypeObject.STRING) {
            throw new IllegalStateException("The type of column is not STRING.");
        }
        return (String)this.value;
    }

    public long aslong() {
        if (this.type != ColumnTypeObject.INTEGER) {
            throw new IllegalStateException("The type of column is not INTEGER.");
        }
        return (Long)this.value;
    }

    public Long asLong() {
        if (this.type != ColumnTypeObject.INTEGER) {
            throw new IllegalStateException("The type of column is not INTEGER.");
        }
        return (Long)this.value;
    }

    public int asInt() {
        if (this.type != ColumnTypeObject.INTEGER) {
            throw new IllegalStateException("The type of column is not INTEGER.");
        }
        return ((Long)this.value).intValue();
    }

    public double asDouble() {
        if (this.type != ColumnTypeObject.DOUBLE) {
            throw new IllegalStateException("The type of column is not DOUBLE.");
        }
        return (Double)this.value;
    }

    public Boolean asBoolean() {
        if (this.type != ColumnTypeObject.BOOLEAN) {
            throw new IllegalStateException("The type of column is not BOOLEAN.");
        }
        return (Boolean)this.value;
    }

    public boolean asboolean() {
        if (this.type != ColumnTypeObject.BOOLEAN) {
            throw new IllegalStateException("The type of column is not BOOLEAN.");
        }
        return (Boolean)this.value;
    }

    public byte[] asBinary() {
        if (this.type != ColumnTypeObject.BINARY) {
            throw new IllegalStateException("The type of column is not BINARY.");
        }
        return (byte[])this.value;
    }

    public static ColumnValueObject fromString(String value) {
        return new ColumnValueObject(value, ColumnTypeObject.STRING);
    }

    public static ColumnValueObject fromLong(Long value) {
        return new ColumnValueObject(value, ColumnTypeObject.INTEGER);
    }

    public static ColumnValueObject fromlong(long value) {
        return new ColumnValueObject(value, ColumnTypeObject.INTEGER);
    }

    public static ColumnValueObject fromInt(int value) {
        return new ColumnValueObject(value, ColumnTypeObject.INTEGER);
    }

    public static ColumnValueObject fromBinary(byte[] value) {
        return new ColumnValueObject(value, ColumnTypeObject.BINARY);
    }

    public static ColumnValueObject fromDouble(double value) {
        return new ColumnValueObject(value, ColumnTypeObject.DOUBLE);
    }

    public static ColumnValueObject fromBoolean(boolean value) {
        return new ColumnValueObject(value, ColumnTypeObject.BOOLEAN);
    }

    public static ColumnValueObject fromBoolean(Boolean value) {
        return new ColumnValueObject(value, ColumnTypeObject.BOOLEAN);
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    public ColumnTypeObject getType() {
        return this.type;
    }

    public void setType(ColumnTypeObject type) {
        this.type = type;
    }
}

