/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver;

import firtoolresolver.FirtoolBinary;
import firtoolresolver.Logger;
import firtoolresolver.Logger$;
import firtoolresolver.shaded.coursier.Fetch;
import firtoolresolver.shaded.coursier.Fetch$;
import firtoolresolver.shaded.coursier.Fetch$FetchTaskOps$;
import firtoolresolver.shaded.coursier.core.Dependency;
import firtoolresolver.shaded.coursier.core.Extension$;
import firtoolresolver.shaded.coursier.core.Module;
import firtoolresolver.shaded.coursier.package$;
import firtoolresolver.shaded.coursier.package$Dependency$;
import firtoolresolver.shaded.coursier.package$Module$;
import firtoolresolver.shaded.coursier.util.Task;
import firtoolresolver.shaded.dev.dirs.ProjectDirectories;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class Resolve$ {
    public static Resolve$ MODULE$;
    private Either<String, String> operatingSystem;
    private Either<String, String> architecture;
    private final Regex firtoolresolver$Resolve$$VersionRegex;
    private volatile byte bitmap$0;

    static {
        new Resolve$();
    }

    private Either<String, String> operatingSystem$lzycompute() {
        Resolve$ resolve$ = this;
        synchronized (resolve$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String osName = System.getProperty("os.name");
                String name = osName.toLowerCase();
                this.operatingSystem = name.startsWith("win") ? scala.package$.MODULE$.Right().apply((Object)"windows") : (name.startsWith("mac") ? scala.package$.MODULE$.Right().apply((Object)"macos") : (name.startsWith("linux") ? scala.package$.MODULE$.Right().apply((Object)"linux") : scala.package$.MODULE$.Left().apply((Object)new StringBuilder(16).append("Unsupported OS: ").append(osName).toString())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.operatingSystem;
    }

    private Either<String, String> operatingSystem() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.operatingSystem$lzycompute();
        }
        return this.operatingSystem;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Either<String, String> architecture$lzycompute() {
        block5: {
            var1_1 = this;
            synchronized (var1_1) {
                if ((byte)(this.bitmap$0 & 2) != 0) break block5;
                osArch = System.getProperty("os.arch");
                v0 = arch = osArch.toLowerCase();
                var4_4 = "amd64";
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = arch;
                var5_5 = "x86_64";
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 /* !! */  = scala.package$.MODULE$.Right().apply((Object)"x64");
                } else {
                    v3 = arch;
                    var6_6 = "aarch64";
                    v2 /* !! */  = !(v3 != null ? v3.equals(var6_6) == false : var6_6 != null) ? scala.package$.MODULE$.Right().apply((Object)"aarch64") : scala.package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Unsupported architecture: ").append(osArch).toString());
                }
                this.architecture = v2 /* !! */ ;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.architecture;
    }

    private Either<String, String> architecture() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.architecture$lzycompute();
        }
        return this.architecture;
    }

    private String groupId() {
        return "org.chipsalliance";
    }

    private String artId() {
        return "llvm-firtool";
    }

    private String appleSiliconFixup(Logger logger, String os, String arch) {
        String string = os;
        String string2 = "macos";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = arch;
            String string4 = "aarch64";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                logger.debug("Using x64 architecture for Apple silicon");
                return "x64";
            }
        }
        return arch;
    }

    private Either<String, String> determinePlatform(Logger logger) {
        return this.operatingSystem().flatMap((Function1 & Serializable & scala.Serializable)os -> MODULE$.architecture().map((Function1 & Serializable & scala.Serializable)_arch -> {
            String arch = MODULE$.appleSiliconFixup(logger, (String)os, (String)_arch);
            return new Tuple2(_arch, (Object)arch);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String arch = (String)tuple2._2();
                return new StringBuilder(1).append((String)os).append("-").append(arch).toString();
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private String binaryName() {
        return "firtool";
    }

    public Regex firtoolresolver$Resolve$$VersionRegex() {
        return this.firtoolresolver$Resolve$$VersionRegex;
    }

    private String cacheDir() {
        String path = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"CHISEL_FIRTOOL_CACHE", (Function0 & Serializable & scala.Serializable)() -> ProjectDirectories.from((String)"", (String)Resolve$.MODULE$.groupId(), (String)Resolve$.MODULE$.artId()).cacheDir);
        return new File(path).getAbsolutePath();
    }

    private Path firtoolBin(String version) {
        Path topDir = Paths.get(this.cacheDir(), new String[0]).resolve(version);
        Path destDir = topDir.resolve("bin");
        return destDir.resolve("firtool");
    }

    private Either<String, Either<String, FirtoolBinary>> checkFirtoolPath(Logger logger) {
        Try result;
        logger.debug("Checking CHISEL_FIRTOOL_PATH for firtool");
        Option firtoolPathOpt = scala.sys.package$.MODULE$.env().get((Object)"CHISEL_FIRTOOL_PATH");
        if (firtoolPathOpt.isEmpty()) {
            String msg = "CHISEL_FIRTOOL_PATH not set";
            logger.debug(msg);
            return Resolve$.Recoverable$1(msg);
        }
        Path firtoolPath = Paths.get((String)firtoolPathOpt.get(), new String[0]).toAbsolutePath();
        if (!Files.exists(firtoolPath, new LinkOption[0])) {
            String msg = new StringBuilder(37).append("CHISEL_FIRTOOL_PATH (").append(firtoolPath).append(") does not exist").toString();
            logger.debug(msg);
            return Resolve$.Unrecoverable$1(msg);
        }
        Path binary = firtoolPath.resolve(this.binaryName());
        Seq cmd = (Seq)new .colon.colon((Object)((Object)binary).toString(), (List)new .colon.colon((Object)"--version", (List)Nil$.MODULE$));
        logger.debug(new StringBuilder(9).append("Running: ").append(cmd.mkString(" ")).toString());
        ArrayBuffer stdouterr = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ProcessLogger procLogger = ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> {
            stdouterr.$plus$eq((Object)x$2);
            return BoxedUnit.UNIT;
        });
        Try try_ = result = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> scala.sys.process.package$.MODULE$.stringSeqToProcess(cmd).$bang(procLogger));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            String msg = e.getMessage();
            logger.debug(msg);
            return Resolve$.Unrecoverable$1(msg);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int exitCode = BoxesRunTime.unboxToInt((Object)success.value());
            String out = stdouterr.mkString("\n");
            Option version = stdouterr.collectFirst((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Option option = Resolve$.MODULE$.firtoolresolver$Resolve$$VersionRegex().unapplySeq(A1);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String v = (String)((LinearSeqOptimized)option.get()).apply(0);
                        return (B1)v;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(String x1) {
                    String string = x1;
                    Option option = Resolve$.MODULE$.firtoolresolver$Resolve$$VersionRegex().unapplySeq((CharSequence)string);
                    return !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
                }
            });
            if (exitCode != 0) {
                String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("|Unable to run firtool binary (").append(binary).append("):\n                |  Exit Code: ").append(exitCode).append("\n                |  Output: '").append(out).append("\n                |").toString())).stripMargin();
                logger.debug(msg);
                return Resolve$.Unrecoverable$1(msg);
            }
            String v = (String)version.getOrElse((Function0 & Serializable & scala.Serializable)() -> "<unknown>");
            return scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Right().apply((Object)new FirtoolBinary(binary.toFile(), v)));
        }
        throw new MatchError((Object)try_);
    }

    private Either<String, FirtoolBinary> checkResources(Option<URLClassLoader> classloader, Logger logger) {
        File destFile;
        String version;
        block9: {
            Either<String, String> platform = this.determinePlatform(logger);
            logger.debug("Checking resources for firtool");
            if (platform.isLeft()) {
                logger.debug((String)Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(platform)));
                return scala.package$.MODULE$.Left().apply(Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(platform)));
            }
            ClassLoader resourceLoader = (ClassLoader)classloader.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader());
            String baseDir = new StringBuilder(1).append(this.groupId()).append("/").append(this.artId()).toString();
            String artDir = new StringBuilder(1).append(baseDir).append("/").append(platform.toOption().get()).toString();
            URL versionFile = resourceLoader.getResource(new StringBuilder(16).append(baseDir).append("/project.version").toString());
            Option versionOpt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Source$.MODULE$.fromURL(versionFile, Codec$.MODULE$.fallbackSystemCodec()).mkString()).toOption();
            if (versionOpt.isEmpty()) {
                String msg = new StringBuilder(41).append("firtool version not found in resources (").append(versionFile).append(")").toString();
                logger.debug(msg);
                return scala.package$.MODULE$.Left().apply((Object)msg);
            }
            version = (String)versionOpt.get();
            logger.debug(new StringBuilder(35).append("Firtool version ").append(version).append(" found in resources").toString());
            Path destBin = this.firtoolBin(version);
            destFile = destBin.toFile();
            Resolve$ resolve$ = this;
            synchronized (resolve$) {
                Left left;
                block8: {
                    if (destFile.isFile()) {
                        logger.debug(new StringBuilder(30).append("Firtool binary ").append(destFile).append(" already exists").toString());
                    } else {
                        logger.debug(new StringBuilder(34).append("Copying firtool from resources to ").append(destFile).toString());
                        InputStream resourceBin = resourceLoader.getResourceAsStream(new StringBuilder(12).append(artDir).append("/bin/firtool").toString());
                        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                            Files.createDirectories(destBin.getParent(), new FileAttribute[0]);
                            Files.copy(resourceBin, destBin, new CopyOption[0]);
                            destFile.setWritable(true);
                            destFile.setReadable(true);
                            return destFile.setExecutable(true);
                        });
                        if (result.isFailure()) {
                            String msg = new StringBuilder(28).append("Copying firtool failed with ").append(result.failed().get()).toString();
                            logger.debug(msg);
                            left = scala.package$.MODULE$.Left().apply((Object)msg);
                            break block8;
                        }
                    }
                    break block9;
                }
                return left;
            }
        }
        return scala.package$.MODULE$.Right().apply((Object)new FirtoolBinary(destFile, version));
    }

    private Either<String, FirtoolBinary> checkInstalled(Logger logger, String defaultVersion) {
        File destFile = this.firtoolBin(defaultVersion).toFile();
        if (destFile.isFile()) {
            logger.debug(new StringBuilder(54).append("Firtool binary with default version (").append(defaultVersion).append(") ").append(destFile).append(" already exists").toString());
            return scala.package$.MODULE$.Right().apply((Object)new FirtoolBinary(destFile, defaultVersion));
        }
        String msg = new StringBuilder(61).append("Firtool binary with default version (").append(defaultVersion).append(") does not already exist").toString();
        logger.debug(msg);
        return scala.package$.MODULE$.Left().apply((Object)msg);
    }

    private Either<String, FirtoolBinary> fetchArtifact(Logger logger, String defaultVersion) {
        Either<String, String> either = this.determinePlatform(logger);
        if (either instanceof Left) {
            Left left = (Left)either;
            String msg = (String)left.value();
            logger.debug(msg);
            return scala.package$.MODULE$.Left().apply((Object)msg);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        String name = (String)right.value();
        String platform = name;
        String org = package$.MODULE$.Organization().apply(this.groupId());
        Module module = package$Module$.MODULE$.apply(org, package$.MODULE$.ModuleName().apply(String.valueOf(this.artId())), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Dependency dep = package$Dependency$.MODULE$.apply(module, defaultVersion).withPublication("", package$.MODULE$.Type().empty(), Extension$.MODULE$.empty(), package$.MODULE$.Classifier().apply(platform));
        logger.debug(new StringBuilder(32).append("Attempting to fetch ").append(dep.module()).append(":").append(dep.version()).append(",clasifier=").append(platform).toString());
        Try resolution = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Fetch<Task> qual$1 = Fetch$.MODULE$.FetchTaskOps(Fetch$.MODULE$.apply().addDependencies((Seq<Dependency>)Predef$.MODULE$.wrapRefArray((Object[])new Dependency[]{dep})));
            ExecutionContext x$1 = Fetch$FetchTaskOps$.MODULE$.run$default$1$extension(qual$1);
            return Fetch$FetchTaskOps$.MODULE$.run$extension(qual$1, x$1);
        });
        if (resolution.isFailure()) {
            String msg = new StringBuilder(1).append(((Throwable)resolution.failed().get()).toString()).append("\n").toString();
            logger.debug(msg);
            return scala.package$.MODULE$.Left().apply((Object)msg);
        }
        File jar = (File)((IterableLike)resolution.get()).head();
        logger.debug(new StringBuilder(21).append("Successfully fetched ").append(jar).toString());
        logger.debug(new StringBuilder(32).append("Loading ").append(jar).append(" to search its resources").toString());
        URLClassLoader classloader = new URLClassLoader((URL[])((Object[])new URL[]{jar.toURL()}));
        return this.checkResources((Option<URLClassLoader>)new Some((Object)classloader), logger);
    }

    public Either<String, FirtoolBinary> apply(String defaultVersion, boolean verbose) {
        Logger logger = verbose ? Logger$.MODULE$.debug() : Logger$.MODULE$.warn();
        return this.apply(logger, defaultVersion);
    }

    public Either<String, FirtoolBinary> apply(Logger logger, String defaultVersion) {
        return this.checkFirtoolPath(logger).flatMap((Function1 & Serializable & scala.Serializable)res -> res.left().flatMap((Function1 & Serializable & scala.Serializable)msg1 -> MODULE$.checkResources((Option<URLClassLoader>)None$.MODULE$, logger).left().flatMap((Function1 & Serializable & scala.Serializable)msg2 -> MODULE$.checkInstalled(logger, defaultVersion).left().flatMap((Function1 & Serializable & scala.Serializable)msg3 -> MODULE$.fetchArtifact(logger, defaultVersion).left().map((Function1 & Serializable & scala.Serializable)msg4 -> new .colon.colon((Object)"Failed to fetch firtool:", (List)new .colon.colon(msg1, (List)new .colon.colon(msg2, (List)new .colon.colon(msg3, (List)new .colon.colon(msg4, (List)Nil$.MODULE$))))).mkString("\n"))))));
    }

    public boolean apply$default$2() {
        return false;
    }

    private static final Either Recoverable$1(String msg) {
        return scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Left().apply((Object)msg));
    }

    private static final Either Unrecoverable$1(String msg) {
        return scala.package$.MODULE$.Left().apply((Object)msg);
    }

    private Resolve$() {
        MODULE$ = this;
        this.firtoolresolver$Resolve$$VersionRegex = new StringOps(Predef$.MODULE$.augmentString("^CIRCT firtool-(\\S+)$")).r();
    }
}

