/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.coursier.cache.shaded.dirs;

import firtoolresolver.shaded.coursier.cache.shaded.dirs.UnsupportedOperatingSystemException;
import firtoolresolver.shaded.coursier.cache.shaded.dirs.Util;

public final class UserDirectories {
    public final String homeDir;
    public final String audioDir;
    public final String desktopDir;
    public final String documentDir;
    public final String downloadDir;
    public final String fontDir;
    public final String pictureDir;
    public final String publicDir;
    public final String templateDir;
    public final String videoDir;

    public static UserDirectories get() {
        return new UserDirectories();
    }

    private UserDirectories() {
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': 
            case 's': {
                String[] stringArray = Util.getXDGUserDirs("MUSIC", "DESKTOP", "DOCUMENTS", "DOWNLOAD", "PICTURES", "PUBLICSHARE", "TEMPLATES", "VIDEOS");
                this.homeDir = System.getProperty("user.home");
                this.audioDir = stringArray[0];
                this.desktopDir = stringArray[1];
                this.documentDir = stringArray[2];
                this.downloadDir = stringArray[3];
                this.fontDir = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), "/fonts", this.homeDir, "/.local/share/fonts");
                this.pictureDir = stringArray[4];
                this.publicDir = stringArray[5];
                this.templateDir = stringArray[6];
                this.videoDir = stringArray[7];
                break;
            }
            case 'm': {
                this.homeDir = System.getProperty("user.home");
                this.audioDir = this.homeDir + "/Music";
                this.desktopDir = this.homeDir + "/Desktop";
                this.documentDir = this.homeDir + "/Documents";
                this.downloadDir = this.homeDir + "/Downloads";
                this.fontDir = this.homeDir + "/Library/Fonts";
                this.pictureDir = this.homeDir + "/Pictures";
                this.publicDir = this.homeDir + "/Public";
                this.templateDir = null;
                this.videoDir = this.homeDir + "/Movies";
                break;
            }
            case 'w': {
                String[] stringArray = Util.getWinDirs("5E6C858F-0E22-4760-9AFE-EA3317B67173", "4BD8D571-6D19-48D3-BE97-422220080E43", "B4BFCC3A-DB2C-424C-B029-7FE99A87C641", "FDD39AD0-238F-46AF-ADB4-6C85480369C7", "374DE290-123F-4565-9164-39C4925E467B", "33E28130-4E1E-4676-835A-98395C3BC3BB", "DFDF76A2-C82A-4D63-906A-5644AC457385", "A63293E8-664E-48DB-A079-DF759E0509F7", "18989B1D-99B5-455B-841C-AB7C74E4DDFC");
                this.homeDir = stringArray[0];
                this.audioDir = stringArray[1];
                this.fontDir = null;
                this.desktopDir = stringArray[2];
                this.documentDir = stringArray[3];
                this.downloadDir = stringArray[4];
                this.pictureDir = stringArray[5];
                this.publicDir = stringArray[6];
                this.templateDir = stringArray[7];
                this.videoDir = stringArray[8];
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("User directories are not supported on " + Util.operatingSystemName);
            }
        }
    }

    public String toString() {
        return "UserDirectories (" + Util.operatingSystemName + "):\n  homeDir     = '" + this.homeDir + "'\n  audioDir    = '" + this.audioDir + "'\n  fontDir     = '" + this.fontDir + "'\n  desktopDir  = '" + this.desktopDir + "'\n  documentDir = '" + this.documentDir + "'\n  downloadDir = '" + this.downloadDir + "'\n  pictureDir  = '" + this.pictureDir + "'\n  publicDir   = '" + this.publicDir + "'\n  templateDir = '" + this.templateDir + "'\n  videoDir    = '" + this.videoDir + "'\n";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UserDirectories userDirectories = (UserDirectories)object;
        if (this.homeDir != null ? !this.homeDir.equals(userDirectories.homeDir) : userDirectories.homeDir != null) {
            return false;
        }
        if (this.audioDir != null ? !this.audioDir.equals(userDirectories.audioDir) : userDirectories.audioDir != null) {
            return false;
        }
        if (this.fontDir != null ? !this.fontDir.equals(userDirectories.fontDir) : userDirectories.fontDir != null) {
            return false;
        }
        if (this.desktopDir != null ? !this.desktopDir.equals(userDirectories.desktopDir) : userDirectories.desktopDir != null) {
            return false;
        }
        if (this.documentDir != null ? !this.documentDir.equals(userDirectories.documentDir) : userDirectories.documentDir != null) {
            return false;
        }
        if (this.downloadDir != null ? !this.downloadDir.equals(userDirectories.downloadDir) : userDirectories.downloadDir != null) {
            return false;
        }
        if (this.pictureDir != null ? !this.pictureDir.equals(userDirectories.pictureDir) : userDirectories.pictureDir != null) {
            return false;
        }
        if (this.publicDir != null ? !this.publicDir.equals(userDirectories.publicDir) : userDirectories.publicDir != null) {
            return false;
        }
        if (this.templateDir != null ? !this.templateDir.equals(userDirectories.templateDir) : userDirectories.templateDir != null) {
            return false;
        }
        return !(this.videoDir != null ? !this.videoDir.equals(userDirectories.videoDir) : userDirectories.videoDir != null);
    }

    public int hashCode() {
        int n = 0;
        n = 31 * n + (this.homeDir != null ? this.homeDir.hashCode() : 0);
        n = 31 * n + (this.audioDir != null ? this.audioDir.hashCode() : 0);
        n = 31 * n + (this.fontDir != null ? this.fontDir.hashCode() : 0);
        n = 31 * n + (this.desktopDir != null ? this.desktopDir.hashCode() : 0);
        n = 31 * n + (this.documentDir != null ? this.documentDir.hashCode() : 0);
        n = 31 * n + (this.downloadDir != null ? this.downloadDir.hashCode() : 0);
        n = 31 * n + (this.pictureDir != null ? this.pictureDir.hashCode() : 0);
        n = 31 * n + (this.publicDir != null ? this.publicDir.hashCode() : 0);
        n = 31 * n + (this.templateDir != null ? this.templateDir.hashCode() : 0);
        n = 31 * n + (this.videoDir != null ? this.videoDir.hashCode() : 0);
        return n;
    }
}

