/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.coursier.paths;

import firtoolresolver.shaded.coursier.paths.CoursierPaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class Mirror {
    private final List<String> from;
    private final String to;
    private final String type;

    public static Mirror of(List<String> list, String string, String string2) {
        return new Mirror(list, string, string2);
    }

    public static File[] defaultConfigFiles() throws IOException {
        String string = System.getenv("COURSIER_MIRRORS");
        if (string != null && !string.isEmpty()) {
            return new File[]{new File(string)};
        }
        String string2 = System.getProperty("firtoolresolver.shaded.coursier.mirrors");
        if (string2 != null && !string2.isEmpty()) {
            return new File[]{new File(string2)};
        }
        File[] fileArray = CoursierPaths.configDirectories();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            File file2 = new File(file, "mirror.properties");
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Deprecated
    public static File defaultConfigFile() throws IOException {
        return Mirror.defaultConfigFiles()[0];
    }

    public static File extraConfigFile() throws IOException {
        String string = System.getenv("COURSIER_EXTRA_MIRRORS");
        if (string != null) {
            return new File(string);
        }
        String string2 = System.getProperty("firtoolresolver.shaded.coursier.mirrors.extra");
        if (string2 != null) {
            return new File(string2);
        }
        return null;
    }

    public static List<Mirror> load() throws MirrorPropertiesException, IOException {
        File file;
        File file2 = Mirror.defaultConfigFile();
        ArrayList<Mirror> arrayList = new ArrayList<Mirror>();
        if (file2.exists()) {
            arrayList.addAll(Mirror.parse(file2));
        }
        if ((file = Mirror.extraConfigFile()) != null && file.exists()) {
            arrayList.addAll(Mirror.parse(file));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<Mirror> parse(File file) throws MirrorPropertiesException, IOException {
        Properties properties = new Properties();
        try (Object object = new FileInputStream(file);){
            properties.load((InputStream)object);
        }
        try {
            object = Mirror.parse(properties);
        }
        catch (MirrorPropertiesException mirrorPropertiesException) {
            throw new MirrorPropertiesException("Parsing " + file, mirrorPropertiesException);
        }
        return object;
    }

    public static List<Mirror> parse(Properties properties) throws MirrorPropertiesException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object iterator : properties.keySet()) {
            if (!(iterator instanceof String) || !((String)iterator).endsWith(".to")) continue;
            arrayList.add((String)iterator);
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string : arrayList) {
            String string2;
            String string3 = string.substring(0, string.length() - 3);
            String string4 = properties.getProperty(string3 + ".from");
            if (string4 == null) {
                throw new MirrorPropertiesException("Property " + string3 + ".from not found");
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string5 : string4.split(Pattern.quote(";"))) {
                if (string5.isEmpty()) continue;
                if (string5.charAt(string5.length() - 1) == '/') {
                    arrayList3.add(string5.substring(0, string5.length() - 1));
                    continue;
                }
                arrayList3.add(string5);
            }
            Object object = properties.getProperty(string);
            if (((String)object).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (!"maven".equals(string2 = properties.getProperty(string3 + ".type", "tree")) && !"tree".equals(string2)) {
                throw new MirrorPropertiesException("Invalid value for property " + string3 + ".type");
            }
            arrayList2.add(Mirror.of(arrayList3, (String)object, string2));
        }
        return arrayList2;
    }

    private Mirror(List<String> list, String string, String string2) {
        this.from = Collections.unmodifiableList(new ArrayList<String>(list));
        this.to = string;
        this.type = string2;
    }

    public List<String> from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public String type() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Mirror) {
            Mirror mirror = (Mirror)object;
            return this.from.equals(mirror.from) && this.to.equals(mirror.to) && this.type.equals(mirror.type);
        }
        return false;
    }

    public int hashCode() {
        int n = 17 + "Mirror".hashCode();
        n = 37 * n + this.from.hashCode();
        n = 37 * n + this.to.hashCode();
        n = 37 * n + this.type.hashCode();
        return 37 * n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Mirror(");
        stringBuilder.append("from=List(");
        boolean bl = true;
        for (String string : this.from) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("), to=");
        stringBuilder.append(this.to);
        stringBuilder.append(", type=");
        stringBuilder.append(this.type);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String transform(String string) {
        return this.matches(string, string);
    }

    public String matches(String string) {
        return this.matches(string, null);
    }

    public String matches(String string, String string2) {
        for (String string3 : this.from) {
            if (!string.startsWith(string3 + "/")) continue;
            return this.to + string.substring(string3.length());
        }
        return string2;
    }

    public static String transform(List<Mirror> list, String string) {
        for (Mirror mirror : list) {
            String string2 = mirror.matches(string);
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    public static class MirrorPropertiesException
    extends Exception {
        public MirrorPropertiesException(String string) {
            super(string);
        }

        public MirrorPropertiesException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static final class Types {
        public static final String MAVEN = "maven";
        public static final String TREE = "tree";
    }
}

