/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.apache.commons.io.input;

import firtoolresolver.shaded.org.apache.commons.io.IOUtils;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(Reader proxy) {
        super(proxy);
    }

    protected void afterRead(int n) throws IOException {
    }

    protected void beforeRead(int n) throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        throw e;
    }

    @Override
    public synchronized void mark(int idx) throws IOException {
        try {
            this.in.mark(idx);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.beforeRead(1);
            int c = this.in.read();
            this.afterRead(c != -1 ? 1 : -1);
            return c;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public int read(char[] chr) throws IOException {
        try {
            this.beforeRead(IOUtils.length(chr));
            int n = this.in.read(chr);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public int read(char[] chr, int st, int len) throws IOException {
        try {
            this.beforeRead(len);
            int n = this.in.read(chr, st, len);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        try {
            this.beforeRead(IOUtils.length(target));
            int n = this.in.read(target);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public boolean ready() throws IOException {
        try {
            return this.in.ready();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return false;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public long skip(long ln) throws IOException {
        try {
            return this.in.skip(ln);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0L;
        }
    }
}

