/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.apache.xbean.recipe;

import firtoolresolver.shaded.org.apache.xbean.recipe.ConstructionException;
import firtoolresolver.shaded.org.apache.xbean.recipe.DefaultExecutionContext;
import firtoolresolver.shaded.org.apache.xbean.recipe.ExecutionContext;
import firtoolresolver.shaded.org.apache.xbean.recipe.Recipe;
import firtoolresolver.shaded.org.apache.xbean.recipe.Reference;
import firtoolresolver.shaded.org.apache.xbean.recipe.UnresolvedReferencesException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecipe
implements Recipe {
    private static final AtomicLong ID = new AtomicLong(1L);
    private long id = ID.getAndIncrement();
    private String name;

    protected AbstractRecipe() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    @Override
    public float getPriority() {
        return 0.0f;
    }

    @Override
    public Object create() throws ConstructionException {
        return this.create(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object create(ClassLoader classLoader) throws ConstructionException {
        ClassLoader oldClassLoader = null;
        if (classLoader != null) {
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Object object = this.create((Type)((Object)Object.class), false);
            return object;
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object create(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        boolean createNewContext;
        if (expectedType == null) {
            throw new NullPointerException("expectedType is null");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        if (oldClassLoader == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        boolean bl = createNewContext = !ExecutionContext.isContextSet();
        if (createNewContext) {
            ExecutionContext.setContext(new DefaultExecutionContext());
        }
        try {
            Object object;
            block15: {
                Recipe popped;
                ExecutionContext context = ExecutionContext.getContext();
                if (this.getName() != null && context.containsObject(this.getName()) && !(context.getObject(this.getName()) instanceof Recipe)) {
                    Object object2 = context.getObject(this.getName());
                    return object2;
                }
                context.push(this);
                try {
                    object = this.internalCreate(expectedType, lazyRefAllowed);
                    popped = context.pop();
                    if (popped == this) break block15;
                }
                catch (Throwable throwable) {
                    Recipe popped2 = context.pop();
                    if (popped2 != this) {
                        throw new IllegalStateException("Internal Error: recipe stack is corrupt: Expected " + this + " to be popped of the stack but " + popped2 + " was");
                    }
                    throw throwable;
                }
                throw new IllegalStateException("Internal Error: recipe stack is corrupt: Expected " + this + " to be popped of the stack but " + popped + " was");
            }
            return object;
        }
        finally {
            if (createNewContext) {
                ExecutionContext context = ExecutionContext.getContext();
                ExecutionContext.setContext(null);
                Map<String, List<Reference>> unresolvedRefs = context.getUnresolvedRefs();
                if (!unresolvedRefs.isEmpty()) {
                    throw new UnresolvedReferencesException(unresolvedRefs);
                }
            }
            if (oldClassLoader == null) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    protected abstract Object internalCreate(Type var1, boolean var2) throws ConstructionException;

    @Override
    public List<Recipe> getNestedRecipes() {
        return Collections.emptyList();
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        return Collections.emptyList();
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        String string = this.getClass().getSimpleName();
        if (string.endsWith("Recipe")) {
            string = string.substring(0, string.length() - "Recipe".length());
        }
        return string + "@" + this.id;
    }
}

