/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.apache.xbean.recipe;

import firtoolresolver.shaded.org.apache.xbean.recipe.AbstractRecipe;
import firtoolresolver.shaded.org.apache.xbean.recipe.ConstructionException;
import firtoolresolver.shaded.org.apache.xbean.recipe.ExecutionContext;
import firtoolresolver.shaded.org.apache.xbean.recipe.NoSuchObjectException;
import firtoolresolver.shaded.org.apache.xbean.recipe.Recipe;
import firtoolresolver.shaded.org.apache.xbean.recipe.RecipeHelper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceNameRecipe
extends AbstractRecipe {
    private String referenceName;

    public ReferenceNameRecipe(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    private Object getReference() {
        if (this.referenceName == null) {
            throw new ConstructionException("Reference name has not been set");
        }
        ExecutionContext context = ExecutionContext.getContext();
        if (!context.containsObject(this.referenceName)) {
            throw new NoSuchObjectException(this.referenceName);
        }
        return context.getObject(this.referenceName);
    }

    @Override
    public List<Recipe> getNestedRecipes() {
        Object object = this.getReference();
        if (object instanceof Recipe) {
            Recipe recipe = (Recipe)object;
            return Collections.singletonList(recipe);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        return this.getNestedRecipes();
    }

    @Override
    public boolean canCreate(Type type) {
        Object object = this.getReference();
        return String.class == RecipeHelper.toClass(type);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Object object = this.getReference();
        return this.referenceName;
    }
}

