/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.dir;

import firtoolresolver.shaded.javax.inject.Named;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.AbstractArchiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.ResourceUtils;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.attributes.SymlinkUtils;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

@Named(value="dir")
public class DirectoryArchiver
extends AbstractArchiver {
    private final List<Runnable> directoryChmods = new ArrayList<Runnable>();
    private long filesCopied;

    public DirectoryArchiver() {
        this.setForced(false);
    }

    public void resetArchiver() throws IOException {
        this.cleanUp();
    }

    @Override
    public void execute() throws ArchiverException, IOException {
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        File destDirectory = this.getDestFile();
        if (destDirectory == null) {
            throw new ArchiverException("You must set the destination directory.");
        }
        if (destDirectory.exists() && !destDirectory.isDirectory()) {
            throw new ArchiverException(destDirectory + " is not a directory.");
        }
        if (destDirectory.exists() && !destDirectory.canWrite()) {
            throw new ArchiverException(destDirectory + " is not writable.");
        }
        this.getLogger().info("Copying files to {}", (Object)destDirectory.getAbsolutePath());
        try {
            while (iter.hasNext()) {
                ArchiveEntry f = iter.next();
                if (ResourceUtils.isSame(f.getResource(), destDirectory)) {
                    throw new ArchiverException("The destination directory cannot include itself.");
                }
                String fileName = f.getName();
                String destDir = destDirectory.getCanonicalPath();
                fileName = destDir + File.separator + fileName;
                PlexusIoResource resource = f.getResource();
                if (resource instanceof SymlinkDestinationSupplier) {
                    String dest = ((SymlinkDestinationSupplier)((Object)resource)).getSymlinkDestination();
                    File target = new File(dest);
                    File symlink = new File(fileName);
                    DirectoryArchiver.makeParentDirectories(symlink);
                    SymlinkUtils.createSymbolicLink(symlink, target);
                    continue;
                }
                this.copyFile(f, fileName);
            }
            this.directoryChmods.forEach(Runnable::run);
            this.directoryChmods.clear();
            if (this.filesCopied > 0L) {
                this.getLogger().info("{} file{} copied to {}", this.filesCopied, this.filesCopied > 0L ? "s" : "", destDirectory.getAbsolutePath());
            } else {
                this.getLogger().info("All files are uptodate in {}", (Object)destDirectory.getAbsolutePath());
            }
            this.filesCopied = 0L;
        }
        catch (IOException ioe) {
            String message = "Problem copying files : " + ioe.getMessage();
            throw new ArchiverException(message, ioe);
        }
    }

    protected void copyFile(ArchiveEntry entry, String vPath) throws ArchiverException, IOException {
        long outLastModified;
        if (vPath.length() <= 0) {
            return;
        }
        PlexusIoResource in = entry.getResource();
        File outFile = new File(vPath);
        long inLastModified = in.getLastModified();
        if (!this.isForced() && ResourceUtils.isUptodate(inLastModified, outLastModified = outFile.lastModified())) {
            return;
        }
        if (!in.isDirectory()) {
            DirectoryArchiver.makeParentDirectories(outFile);
            try (InputStream input = entry.getInputStream();){
                ResourceUtils.copyFile(input, outFile);
            }
            ++this.filesCopied;
            this.setFileModes(entry, outFile, inLastModified);
        } else {
            if (outFile.exists()) {
                if (!outFile.isDirectory()) {
                    throw new ArchiverException("Expected directory and found file at copy destination of " + in.getName() + " to " + outFile);
                }
            } else if (!outFile.mkdirs()) {
                throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
            }
            this.directoryChmods.add(() -> {
                try {
                    this.setFileModes(entry, outFile, inLastModified);
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed setting file attributes", e);
                }
            });
        }
    }

    private static void makeParentDirectories(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ArchiverException("Unable to create directory or parent directory of " + file);
        }
    }

    private void setFileModes(ArchiveEntry entry, File outFile, long inLastModified) throws IOException {
        if (!this.isIgnorePermissions()) {
            ArchiveEntryUtils.chmod(outFile, entry.getMode());
        }
        if (this.getLastModifiedTime() == null) {
            FileTime fromMillis = FileTime.fromMillis(inLastModified == 0L ? System.currentTimeMillis() : inLastModified);
            Files.setLastModifiedTime(outFile.toPath(), fromMillis);
        } else {
            Files.setLastModifiedTime(outFile.toPath(), this.getLastModifiedTime());
        }
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.setIncludeEmptyDirs(false);
        this.setIncludeEmptyDirs(true);
    }

    @Override
    protected void close() throws IOException {
    }

    @Override
    protected String getArchiveType() {
        return "directory";
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }
}

