/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.component.composition;

import firtoolresolver.shaded.org.codehaus.plexus.component.composition.CompositionResolver;
import firtoolresolver.shaded.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import firtoolresolver.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import firtoolresolver.shaded.org.codehaus.plexus.component.repository.ComponentRequirement;
import firtoolresolver.shaded.org.codehaus.plexus.component.repository.ComponentRequirementList;
import firtoolresolver.shaded.org.codehaus.plexus.util.StringUtils;
import firtoolresolver.shaded.org.codehaus.plexus.util.dag.CycleDetectedException;
import firtoolresolver.shaded.org.codehaus.plexus.util.dag.DAG;
import java.util.List;

public class DefaultCompositionResolver
implements CompositionResolver {
    private DAG dag = new DAG();

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CycleDetectedInComponentGraphException {
        String key = this.getDAGKey(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
        List<ComponentRequirement> requirements = componentDescriptor.getRequirements();
        for (ComponentRequirement requirement : requirements) {
            try {
                if (requirement instanceof ComponentRequirementList) {
                    for (String hint : ((ComponentRequirementList)requirement).getRoleHints()) {
                        this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), hint));
                    }
                    continue;
                }
                this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), requirement.getRoleHint()));
            }
            catch (CycleDetectedException e) {
                throw new CycleDetectedInComponentGraphException("Cyclic requirement detected", e);
            }
        }
    }

    @Override
    public List getRequirements(String role, String roleHint) {
        return this.dag.getChildLabels(this.getDAGKey(role, roleHint));
    }

    @Override
    public List findRequirements(String role, String roleHint) {
        return this.dag.getParentLabels(this.getDAGKey(role, roleHint));
    }

    private String getDAGKey(String role, String roleHint) {
        return role + ':' + (StringUtils.isNotEmpty(roleHint) ? roleHint : "default");
    }
}

