/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.lookup;

import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultConverterLookup
implements ConverterLookup {
    private final List<ConfigurationConverter> converters = new ArrayList<ConfigurationConverter>();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();
    private final Map<Class<?>, ConfigurationConverter> converterMap = new ConcurrentHashMap();

    public DefaultConverterLookup() {
        this.registerDefaultBasicConverters();
        this.registerDefaultCompositeConverters();
    }

    @Override
    public synchronized void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    protected void registerDefaultConverter(ConfigurationConverter converter) {
        this.converters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type) throws ComponentConfigurationException {
        ConfigurationConverter retValue = this.converterMap.get(type);
        if (retValue == null) {
            if (this.customConverters != null) {
                retValue = this.findConverterForType(this.customConverters, type);
            }
            if (retValue == null) {
                retValue = this.findConverterForType(this.converters, type);
            }
            if (retValue == null) {
                throw new ComponentConfigurationException("Configuration converter lookup failed for type: " + type);
            }
            this.converterMap.put(type, retValue);
        }
        return retValue;
    }

    private ConfigurationConverter findConverterForType(List<ConfigurationConverter> converters, Class<?> type) {
        for (ConfigurationConverter converter : converters) {
            if (!converter.canConvert(type)) continue;
            return converter;
        }
        return null;
    }

    private void registerDefaultBasicConverters() {
        this.registerDefaultConverter(new BooleanConverter());
        this.registerDefaultConverter(new ByteConverter());
        this.registerDefaultConverter(new CharConverter());
        this.registerDefaultConverter(new DoubleConverter());
        this.registerDefaultConverter(new FloatConverter());
        this.registerDefaultConverter(new IntConverter());
        this.registerDefaultConverter(new LongConverter());
        this.registerDefaultConverter(new ShortConverter());
        this.registerDefaultConverter(new StringBufferConverter());
        this.registerDefaultConverter(new StringConverter());
        this.registerDefaultConverter(new DateConverter());
        this.registerDefaultConverter(new FileConverter());
        this.registerDefaultConverter(new UrlConverter());
        this.registerDefaultConverter(new UriConverter());
        this.registerDefaultConverter(new EnumConverter());
    }

    private void registerDefaultCompositeConverters() {
        this.registerDefaultConverter(new MapConverter());
        this.registerDefaultConverter(new ArrayConverter());
        this.registerDefaultConverter(new CollectionConverter());
        this.registerDefaultConverter(new PropertiesConverter());
        this.registerDefaultConverter(new PlexusConfigurationConverter());
        this.registerDefaultConverter(new ObjectWithFieldsConverter());
    }
}

