/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.logging;

import firtoolresolver.shaded.org.codehaus.plexus.logging.AbstractLogger;
import firtoolresolver.shaded.org.codehaus.plexus.logging.AbstractLoggerManager;
import firtoolresolver.shaded.org.codehaus.plexus.logging.Logger;
import firtoolresolver.shaded.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private Map loggerCache = new HashMap();
    private String threshold = "info";
    private int currentThreshold;

    @Override
    public void initialize() {
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.currentThreshold = 0;
        }
    }

    protected int parseThreshold(String text2) {
        if ((text2 = text2.trim().toLowerCase(Locale.ENGLISH)).equals("debug")) {
            return 0;
        }
        if (text2.equals("info")) {
            return 1;
        }
        if (text2.equals("warn")) {
            return 2;
        }
        if (text2.equals("error")) {
            return 3;
        }
        if (text2.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    @Override
    public void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Object o : this.loggerCache.values()) {
            Logger logger = (Logger)o;
            logger.setThreshold(currentThreshold);
        }
    }

    @Override
    public int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public void setThreshold(String role, String roleHint, int threshold) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return;
        }
        logger.setThreshold(threshold);
    }

    @Override
    public int getThreshold(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return 0;
        }
        return logger.getThreshold();
    }

    @Override
    public Logger getLoggerForComponent(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Logger logger = (Logger)this.loggerCache.get(key);
        if (logger != null) {
            return logger;
        }
        logger = this.createLogger(key);
        this.loggerCache.put(key, logger);
        return logger;
    }

    protected abstract Logger createLogger(String var1);

    @Override
    public void returnComponentLogger(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Object obj = this.loggerCache.remove(key);
        if (obj == null) {
            System.err.println("There was no such logger '" + key + "' " + this.hashCode() + ".");
        }
    }

    @Override
    public int getActiveLoggerCount() {
        return this.loggerCache.size();
    }

    public String getThresholdAsString() {
        return this.threshold;
    }
}

