/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.coursier.cache;

import firtoolresolver.shaded.coursier.cache.ArchiveCache$;
import firtoolresolver.shaded.coursier.cache.ArchiveType;
import firtoolresolver.shaded.coursier.cache.ArtifactError;
import firtoolresolver.shaded.coursier.cache.Cache;
import firtoolresolver.shaded.coursier.cache.CacheLocks$;
import firtoolresolver.shaded.coursier.cache.CacheLogger;
import firtoolresolver.shaded.coursier.cache.CacheLogger$;
import firtoolresolver.shaded.coursier.cache.FileCache$;
import firtoolresolver.shaded.coursier.cache.UnArchiver;
import firtoolresolver.shaded.coursier.cache.UnArchiver$;
import firtoolresolver.shaded.coursier.paths.CachePath;
import firtoolresolver.shaded.coursier.util.Artifact;
import firtoolresolver.shaded.coursier.util.Monad$ops$;
import firtoolresolver.shaded.coursier.util.Sync;
import firtoolresolver.shaded.coursier.util.Task;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0013'\u0005-B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005w!Aq\u0005\u0001BC\u0002\u0013\u0005A\t\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0004}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006O\u0002!\ta\u001c\u0005\u0006g\u0002!Ia\u0018\u0005\u0006i\u0002!I!\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002~\u0001!\t%a \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0011\u0001\u0005B\u0005\u001duaBAGM!\u0005\u0011q\u0012\u0004\u0007K\u0019B\t!!%\t\r\u001ddB\u0011AAJ\u0011\u001d\t)\n\bC\u0001\u0003/C\u0011\"a+\u001d#\u0003%\t!!,\t\u000f\u0005MG\u0004\"\u0003\u0002V\"9\u0011\u0011\u001d\u000f\u0005\n\u0005\r\bbBAK9\u0011\u0005\u0011Q \u0005\b\u0003+cB\u0011\u0001B\n\u0011%\u0011y\u0003HA\u0001\n\u0013\u0011\tD\u0001\u0007Be\u000eD\u0017N^3DC\u000eDWMC\u0002(\u0005\u0003\nQaY1dQ\u0016T1!\u000bB#\u0003!\u0019w.\u001e:tS\u0016\u00148\u0001A\u000b\u0003Y-\u001bB\u0001A\u00174mA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"A\f\u001b\n\u0005Uz#a\u0002)s_\u0012,8\r\u001e\t\u0003]]J!\u0001O\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00111|7-\u0019;j_:,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\n!![8\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u0005\r&dW-A\u0005m_\u000e\fG/[8oAU\tQ\tE\u0002G\u000f&k\u0011AJ\u0005\u0003\u0011\u001a\u0012QaQ1dQ\u0016\u0004\"AS&\r\u0001\u0011)A\n\u0001b\u0001\u001b\n\ta)\u0006\u0002O+F\u0011qJ\u0015\t\u0003]AK!!U\u0018\u0003\u000f9{G\u000f[5oOB\u0011afU\u0005\u0003)>\u00121!\u00118z\t\u001516J1\u0001O\u0005\u0005y\u0016AB2bG\",\u0007%\u0001\u0006v]\u0006\u00138\r[5wKJ,\u0012A\u0017\t\u0003\rnK!\u0001\u0018\u0014\u0003\u0015Us\u0017I]2iSZ,'/A\u0006v]\u0006\u00138\r[5wKJ\u0004\u0013\u0001B:z]\u000e,\u0012\u0001\u0019\t\u0004C\u0012LU\"\u00012\u000b\u0005\rD\u0013\u0001B;uS2L!!\u001a2\u0003\tMKhnY\u0001\u0006gft7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%dWN\u001c\u000b\u0003U.\u00042A\u0012\u0001J\u0011\u0015q\u0016\u0002q\u0001a\u0011\u0015I\u0014\u00021\u0001<\u0011\u00159\u0013\u00021\u0001F\u0011\u0015A\u0016\u00021\u0001[)\t\u0001(\u000f\u0006\u0002kc\")aL\u0003a\u0002A\")\u0011H\u0003a\u0001w\u0005\t1+\u0001\u0005m_\u000e\fG\u000eR5s)\tYd\u000fC\u0003x\u0019\u0001\u0007\u00010\u0001\u0005beRLg-Y2u!\t\t\u00170\u0003\u0002{E\nA\u0011I\u001d;jM\u0006\u001cG/A\u0006hKRLe-\u0012=jgR\u001cHcA?\u0002\"A\u0019!j\u0013@\u0011\u000f}\fy!!\u0006\u0002\u001c9!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004U\u00051AH]8pizJ\u0011\u0001M\u0005\u0004\u0003\u001by\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003\u001by\u0003c\u0001$\u0002\u0018%\u0019\u0011\u0011\u0004\u0014\u0003\u001b\u0005\u0013H/\u001b4bGR,%O]8s!\u0011q\u0013QD\u001e\n\u0007\u0005}qF\u0001\u0004PaRLwN\u001c\u0005\u0006o6\u0001\r\u0001_\u0001\u0004O\u0016$H\u0003BA\u0014\u0003W\u0001BAS&\u0002*A1q0a\u0004\u0002\u0016mBQa\u001e\bA\u0002a\fAb^5uQ2{7-\u0019;j_:$2A[A\u0019\u0011\u0015It\u00021\u0001<\u0003%9\u0018\u000e\u001e5DC\u000eDW\rF\u0002k\u0003oAQa\n\tA\u0002\u0015\u000bab^5uQVs\u0017I]2iSZ,'\u000fF\u0002k\u0003{AQ\u0001W\tA\u0002i\u000b\u0001b^5uQNKhn\u0019\u000b\u0004U\u0006\r\u0003\"\u00020\u0013\u0001\u0004\u0001\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=s(\u0001\u0003mC:<\u0017\u0002BA*\u0003\u001b\u0012aa\u0015;sS:<\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0013q\f\t\u0004]\u0005m\u0013bAA/_\t9!i\\8mK\u0006t\u0007BBA1)\u0001\u0007!+A\u0002pE*\fa!Z9vC2\u001cH\u0003BA-\u0003OBa!!\u0019\u0016\u0001\u0004\u0011\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0004c\u0001\u0018\u0002p%\u0019\u0011\u0011O\u0018\u0003\u0007%sG/A\u0003ukBdW-\u0006\u0002\u0002xA9a&!\u001f<\u000bj\u0003\u0017bAA>_\t1A+\u001e9mKR\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA%\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007I\u000bI\tC\u0004\u0002\fj\u0001\r!!\u001c\u0002\u00039\fA\"\u0011:dQ&4XmQ1dQ\u0016\u0004\"A\u0012\u000f\u0014\u0007qic\u0007\u0006\u0002\u0002\u0010\u0006)\u0011\r\u001d9msV!\u0011\u0011TAQ)\t\tY\n\u0006\u0003\u0002\u001e\u0006\u001d\u0006\u0003\u0002$\u0001\u0003?\u00032ASAQ\t\u0019aeD1\u0001\u0002$V\u0019a*!*\u0005\rY\u000b\tK1\u0001O\u0011!\u0019h\u0004%AA\u0004\u0005%\u0006\u0003B1e\u0003?\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0005\u0003_\u000bi\r\u0006\u0002\u00022*\"\u00111WA^!\u0011\tG-!.\u0011\u0007\u0005\f9,C\u0002\u0002:\n\u0014A\u0001V1tW.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002H>\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004M?\t\u0007\u0011qZ\u000b\u0004\u001d\u0006EGA\u0002,\u0002N\n\u0007a*A\beK2,G/\u001a*fGV\u00148/\u001b<f)\u0011\t9.!8\u0011\u00079\nI.C\u0002\u0002\\>\u0012A!\u00168ji\"1\u0011q\u001c\u0011A\u0002m\n\u0011AZ\u0001\fCJ\u001c\u0007.\u001b<f)f\u0004X\r\u0006\u0003\u0002f\u0006-\bc\u0001$\u0002h&\u0019\u0011\u0011\u001e\u0014\u0003\u0017\u0005\u00138\r[5wKRK\b/\u001a\u0005\b\u0003[\f\u0003\u0019AAx\u0003\r)(\u000f\u001c\t\u0005\u0003c\fIP\u0004\u0003\u0002t\u0006U\bcAA\u0002_%\u0019\u0011q_\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019&a?\u000b\u0007\u0005]x&\u0006\u0003\u0002\u0000\n\u001dA\u0003\u0002B\u0001\u0005#!BAa\u0001\u0003\u000eA!a\t\u0001B\u0003!\rQ%q\u0001\u0003\u0007\u0019\n\u0012\rA!\u0003\u0016\u00079\u0013Y\u0001\u0002\u0004W\u0005\u000f\u0011\rA\u0014\u0005\u0007=\n\u0002\u001dAa\u0004\u0011\t\u0005$'Q\u0001\u0005\u0006s\t\u0002\raO\u000b\u0005\u0005+\u0011i\u0002\u0006\u0005\u0003\u0018\t\u001d\"\u0011\u0006B\u0017)\u0011\u0011IBa\t\u0011\t\u0019\u0003!1\u0004\t\u0004\u0015\nuAA\u0002'$\u0005\u0004\u0011y\"F\u0002O\u0005C!aA\u0016B\u000f\u0005\u0004q\u0005B\u00020$\u0001\b\u0011)\u0003\u0005\u0003bI\nm\u0001\"B\u001d$\u0001\u0004Y\u0004BB\u0014$\u0001\u0004\u0011Y\u0003\u0005\u0003G\u000f\nm\u0001\"\u0002-$\u0001\u0004Q\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\r\u0011\t\u0005-#QG\u0005\u0005\u0005o\tiE\u0001\u0004PE*,7\r^\u0001\u0010M&\u0014Ho\\8me\u0016\u001cx\u000e\u001c<fe*\u0011!\u0011H\u0001\u0007g\"\fG-\u001a3\u000b\t\tu\"1\b\u0006\u0004S\t}\"B\u0001B\u001d\u0015\u0011\u0011iDa\u0011")
public final class ArchiveCache<F>
implements Product,
scala.Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File file, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(file, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File file, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(file, sync);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(sync);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.user()).orNull(Predef$.MODULE$.$conforms()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dir.exists()), this.sync()).map((Function1 & Serializable & scala.Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
                        File[] fileArray = dir.listFiles();
                        Option option = Array$.MODULE$.unapplySeq((Object)fileArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                            File f = (File)((SeqLike)option.get()).apply(0);
                            return package$.MODULE$.Right().apply((Object)new Some((Object)f));
                        }
                        return package$.MODULE$.Right().apply((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return this.S().point(package$.MODULE$.Left().apply((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                return this.extract$1(f, false, dir, archiveType0);
            }
            throw new MatchError((Object)either);
        });
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean((Object)x0$2)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Either either = x0$4;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    File dir = (File)right.value();
                    return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
                        File[] fileArray = dir.listFiles();
                        Option option = Array$.MODULE$.unapplySeq((Object)fileArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                            File f = (File)((SeqLike)option.get()).apply(0);
                            return package$.MODULE$.Right().apply((Object)f);
                        }
                        return package$.MODULE$.Right().apply((Object)dir);
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple4<File, Cache<F>, UnArchiver, Sync<F>> tuple() {
        return new Tuple4((Object)this.location(), this.cache(), (Object)this.unArchiver(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return package$.MODULE$.Right().apply((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (deleteDest || !dir$3.exists()) {
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                            return;
                        }
                        ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        return;
                    }
                    ArchiveCache.moveToDest$1(tmp, dir$3);
                    return;
                }
            }, (Function0 & Serializable & scala.Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return package$.MODULE$.Right().apply((Object)dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        boolean bl = x0$2;
        if (bl) {
            if (artifact$1.changing()) {
                return Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Either either = x0$3;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        ArtifactError err = (ArtifactError)left.value();
                        return $this.S().point(package$.MODULE$.Left().apply((Object)err));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        File f = (File)right.value();
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
                        }
                        return $this.extract$1(f, true, dir$3, archiveType0$1);
                    }
                    throw new MatchError((Object)either);
                });
            }
            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
        }
        if (!bl) {
            return downloadAndExtract$1;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), sync);
    }
}

