/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.apache.commons.compress.compressors.pack200;

import firtoolresolver.shaded.org.apache.commons.compress.compressors.CompressorInputStream;
import firtoolresolver.shaded.org.apache.commons.compress.compressors.pack200.AbstractStreamBridge;
import firtoolresolver.shaded.org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import firtoolresolver.shaded.org.apache.commons.compress.java.util.jar.Pack200;
import firtoolresolver.shaded.org.apache.commons.compress.utils.CloseShieldFilterInputStream;
import firtoolresolver.shaded.org.apache.commons.compress.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.jar.JarOutputStream;

public class Pack200CompressorInputStream
extends CompressorInputStream {
    private static final byte[] CAFE_DOOD = new byte[]{-54, -2, -48, 13};
    private static final int SIG_LENGTH = CAFE_DOOD.length;
    private final InputStream originalInput;
    private final AbstractStreamBridge abstractStreamBridge;

    public static boolean matches(byte[] signature, int length) {
        if (length < SIG_LENGTH) {
            return false;
        }
        for (int i = 0; i < SIG_LENGTH; ++i) {
            if (signature[i] == CAFE_DOOD[i]) continue;
            return false;
        }
        return true;
    }

    public Pack200CompressorInputStream(File f) throws IOException {
        this(f, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorInputStream(File f, Map<String, String> props) throws IOException {
        this(f, Pack200Strategy.IN_MEMORY, props);
    }

    public Pack200CompressorInputStream(File f, Pack200Strategy mode) throws IOException {
        this(null, f, mode, null);
    }

    public Pack200CompressorInputStream(File f, Pack200Strategy mode, Map<String, String> props) throws IOException {
        this(null, f, mode, props);
    }

    public Pack200CompressorInputStream(InputStream in) throws IOException {
        this(in, Pack200Strategy.IN_MEMORY);
    }

    private Pack200CompressorInputStream(InputStream in, File f, Pack200Strategy mode, Map<String, String> props) throws IOException {
        block12: {
            this.originalInput = in;
            this.abstractStreamBridge = mode.newStreamBridge();
            try (JarOutputStream jarOut = new JarOutputStream(this.abstractStreamBridge);){
                Pack200.Unpacker u = Pack200.newUnpacker();
                if (props != null) {
                    u.properties().putAll(props);
                }
                if (f == null) {
                    try (CloseShieldFilterInputStream closeShield = new CloseShieldFilterInputStream(in);){
                        u.unpack(closeShield, jarOut);
                        break block12;
                    }
                }
                u.unpack(f, jarOut);
            }
        }
    }

    public Pack200CompressorInputStream(InputStream in, Map<String, String> props) throws IOException {
        this(in, Pack200Strategy.IN_MEMORY, props);
    }

    public Pack200CompressorInputStream(InputStream in, Pack200Strategy mode) throws IOException {
        this(in, null, mode, null);
    }

    public Pack200CompressorInputStream(InputStream in, Pack200Strategy mode, Map<String, String> props) throws IOException {
        this(in, null, mode, props);
    }

    @Override
    public int available() throws IOException {
        return this.abstractStreamBridge.getInput().available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.abstractStreamBridge.stop();
        }
        finally {
            if (this.originalInput != null) {
                this.originalInput.close();
            }
        }
    }

    @Override
    public synchronized void mark(int limit) {
        try {
            this.abstractStreamBridge.getInput().mark(limit);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.abstractStreamBridge.getInput().markSupported();
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public int read() throws IOException {
        return this.abstractStreamBridge.getInput().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.abstractStreamBridge.getInput().read(b);
    }

    @Override
    public int read(byte[] b, int off, int count) throws IOException {
        return this.abstractStreamBridge.getInput().read(b, off, count);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abstractStreamBridge.getInput().reset();
    }

    @Override
    public long skip(long count) throws IOException {
        return IOUtils.skip(this.abstractStreamBridge.getInput(), count);
    }
}

