/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.apache.xbean.propertyeditor;

import firtoolresolver.shaded.org.apache.xbean.propertyeditor.Converter;
import firtoolresolver.shaded.org.apache.xbean.propertyeditor.PropertyEditorException;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class CollectionUtil {
    public static List toList(String text2, PropertyEditor componentEditor) {
        if (text2.length() == 0) {
            return null;
        }
        if (text2.startsWith("[") && text2.endsWith("]")) {
            text2 = text2.substring(1, text2.length() - 1).trim();
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (text2.length() > 0) {
            StringTokenizer stok = new StringTokenizer(text2, ",");
            while (stok.hasMoreTokens()) {
                String innerText = stok.nextToken();
                Object value = CollectionUtil.componentToObject(innerText, componentEditor);
                list.add(value);
            }
        }
        return list;
    }

    public static String toString(Collection values, PropertyEditor componentEditor) {
        if (values.size() == 0) {
            return "[]";
        }
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        for (Object object : values) {
            String text2 = CollectionUtil.componentToString(object, componentEditor);
            if (i > 0) {
                result.append(",");
            }
            result.append(text2);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static final Map toMap(String text2, PropertyEditor keyEditor, PropertyEditor valueEditor) {
        Properties properties = new Properties();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text2.getBytes());
            properties.load(stream);
        }
        catch (IOException e) {
            throw new PropertyEditorException(e);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String keyText = (String)entry.getKey();
            String valueText = (String)entry.getValue();
            Object keyObject = CollectionUtil.componentToObject(keyText, keyEditor);
            Object valueObject = CollectionUtil.componentToObject(valueText, valueEditor);
            map.put(keyObject, valueObject);
        }
        return map;
    }

    public static final String toString(Map map, PropertyEditor keyEditor, PropertyEditor valueEditor) {
        Properties properties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            Object keyObject = entry.getKey();
            Object valueObject = entry.getValue();
            String keyText = CollectionUtil.componentToString(keyObject, keyEditor);
            String valueText = CollectionUtil.componentToString(valueObject, valueEditor);
            properties.setProperty(keyText, valueText);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store(out, null);
            String text2 = new String(out.toByteArray());
            return text2;
        }
        catch (IOException e) {
            throw new PropertyEditorException(e);
        }
    }

    private static final String componentToString(Object value, PropertyEditor componentEditor) {
        if (value == null) {
            return null;
        }
        if (componentEditor instanceof Converter) {
            Converter converter = (Converter)componentEditor;
            Class type = converter.getType();
            if (!type.isInstance(value)) {
                throw new PropertyEditorException("Value is not an instance of " + type.getSimpleName() + ": " + value.getClass().getName());
            }
            return converter.toString(value);
        }
        componentEditor.setValue(value);
        String text2 = componentEditor.getAsText();
        return text2;
    }

    private static final Object componentToObject(String text2, PropertyEditor componentEditor) {
        if (text2 == null) {
            return null;
        }
        if (componentEditor instanceof Converter) {
            Converter converter = (Converter)componentEditor;
            Object value = converter.toObject(text2.trim());
            return value;
        }
        componentEditor.setAsText(text2);
        Object value = componentEditor.getValue();
        return value;
    }
}

