/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.bzip2;

import firtoolresolver.shaded.javax.inject.Named;
import firtoolresolver.shaded.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.AbstractUnArchiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

@Named(value="bzip2")
public class BZip2UnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_BZIP2 = "bzip2";

    public BZip2UnArchiver() {
    }

    public BZip2UnArchiver(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(BZip2UnArchiver.getBZip2InputStream(Streams.bufferedInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_BZIP2))), Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile(), OPERATION_BZIP2)), OPERATION_BZIP2);
        }
    }

    @Nonnull
    public static BZip2CompressorInputStream getBZip2InputStream(InputStream bis) throws ArchiverException {
        try {
            return new BZip2CompressorInputStream(bis);
        }
        catch (IOException e) {
            throw new ArchiverException("Trouble creating BZIP2 compressor, invalid file ?", e);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in BZIP2 format.");
    }
}

