/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.gzip;

import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.Compressor;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZipCompressor
extends Compressor {
    private OutputStream zOut;

    @Override
    public void compress() throws ArchiverException {
        try {
            this.zOut = Streams.bufferedOutputStream(new GZIPOutputStream(Streams.fileOutputStream(this.getDestFile())));
            this.compress(this.getSource(), this.zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating gzip " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
    }

    @Override
    public void close() {
        try {
            if (this.zOut != null) {
                this.zOut.close();
                this.zOut = null;
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Failure closing target.", e);
        }
    }
}

