/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.gzip;

import firtoolresolver.shaded.javax.inject.Named;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.AbstractUnArchiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

@Named(value="gzip")
public class GZipUnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_GZIP = "gzip";

    public GZipUnArchiver() {
    }

    public GZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(this.getGzipInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_GZIP)), Streams.fileOutputStream(this.getDestFile(), OPERATION_GZIP), OPERATION_GZIP);
        }
    }

    private InputStream getGzipInputStream(InputStream in) throws ArchiverException {
        try {
            return Streams.bufferedInputStream(new GZIPInputStream(in));
        }
        catch (IOException e) {
            throw new ArchiverException("Problem creating GZIP input stream", e);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in GZIP format.");
    }
}

