/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.manager;

import firtoolresolver.shaded.javax.inject.Inject;
import firtoolresolver.shaded.javax.inject.Named;
import firtoolresolver.shaded.javax.inject.Provider;
import firtoolresolver.shaded.javax.inject.Singleton;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.Archiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.UnArchiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.manager.ArchiverManager;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import firtoolresolver.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@Singleton
@Named
public class DefaultArchiverManager
implements ArchiverManager {
    private final Map<String, Provider<Archiver>> archivers;
    private final Map<String, Provider<UnArchiver>> unArchivers;
    private final Map<String, Provider<PlexusIoResourceCollection>> plexusIoResourceCollections;

    @Inject
    public DefaultArchiverManager(Map<String, Provider<Archiver>> archivers, Map<String, Provider<UnArchiver>> unArchivers, Map<String, Provider<PlexusIoResourceCollection>> plexusIoResourceCollections) {
        this.archivers = Objects.requireNonNull(archivers);
        this.unArchivers = Objects.requireNonNull(unArchivers);
        this.plexusIoResourceCollections = Objects.requireNonNull(plexusIoResourceCollections);
    }

    @Override
    @Nonnull
    public Archiver getArchiver(@Nonnull String archiverName) throws NoSuchArchiverException {
        Objects.requireNonNull(archiverName);
        Provider<Archiver> archiver = this.archivers.get(archiverName);
        if (archiver == null) {
            throw new NoSuchArchiverException(archiverName);
        }
        return archiver.get();
    }

    @Override
    @Nonnull
    public UnArchiver getUnArchiver(@Nonnull String unArchiverName) throws NoSuchArchiverException {
        Objects.requireNonNull(unArchiverName);
        Provider<UnArchiver> unArchiver = this.unArchivers.get(unArchiverName);
        if (unArchiver == null) {
            throw new NoSuchArchiverException(unArchiverName);
        }
        return unArchiver.get();
    }

    @Override
    @Nonnull
    public PlexusIoResourceCollection getResourceCollection(String resourceCollectionName) throws NoSuchArchiverException {
        Objects.requireNonNull(resourceCollectionName);
        Provider<PlexusIoResourceCollection> resourceCollection = this.plexusIoResourceCollections.get(resourceCollectionName);
        if (resourceCollection == null) {
            throw new NoSuchArchiverException(resourceCollectionName);
        }
        return resourceCollection.get();
    }

    @Nonnull
    private static String getFileExtension(@Nonnull File file) {
        String fileName = file.getName().toLowerCase(Locale.ROOT);
        String[] tokens = StringUtils.split(fileName, ".");
        String archiveExt = "";
        if (tokens.length == 2) {
            archiveExt = tokens[1];
        } else if (tokens.length > 2 && "tar".equals(tokens[tokens.length - 2])) {
            archiveExt = "tar." + tokens[tokens.length - 1];
        } else if (tokens.length > 2) {
            archiveExt = tokens[tokens.length - 1];
        }
        return archiveExt;
    }

    @Override
    @Nonnull
    public Archiver getArchiver(@Nonnull File file) throws NoSuchArchiverException {
        return this.getArchiver(DefaultArchiverManager.getFileExtension(file));
    }

    @Override
    public Collection<String> getAvailableArchivers() {
        return this.archivers.keySet();
    }

    @Override
    @Nonnull
    public UnArchiver getUnArchiver(@Nonnull File file) throws NoSuchArchiverException {
        return this.getUnArchiver(DefaultArchiverManager.getFileExtension(file));
    }

    @Override
    @Nonnull
    public Collection<String> getAvailableUnArchivers() {
        return this.unArchivers.keySet();
    }

    @Override
    @Nonnull
    public PlexusIoResourceCollection getResourceCollection(@Nonnull File file) throws NoSuchArchiverException {
        return this.getResourceCollection(DefaultArchiverManager.getFileExtension(file));
    }

    @Override
    @Nonnull
    public Collection<String> getAvailableResourceCollections() {
        return this.plexusIoResourceCollections.keySet();
    }
}

