/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.snappy;

import firtoolresolver.shaded.javax.inject.Named;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.AbstractArchiver;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.snappy.SnappyCompressor;
import java.io.IOException;

@Named(value="snappy")
public class SnappyArchiver
extends AbstractArchiver {
    private final SnappyCompressor compressor = new SnappyCompressor();

    @Override
    public void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        ArchiveEntry entry = iter.next();
        if (iter.hasNext()) {
            throw new ArchiverException("There is more than one file in input.");
        }
        this.compressor.setSource(entry.getResource());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected void close() {
        this.compressor.close();
    }

    @Override
    protected String getArchiveType() {
        return "snappy";
    }
}

