/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.archiver.util;

import firtoolresolver.shaded.org.codehaus.plexus.archiver.ArchiverException;
import firtoolresolver.shaded.org.codehaus.plexus.archiver.util.Streams;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import firtoolresolver.shaded.org.slf4j.Logger;
import firtoolresolver.shaded.org.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Compressor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File destFile;
    private PlexusIoResource source;

    protected Logger getLogger() {
        return this.logger;
    }

    public void setDestFile(File compressFile) {
        this.destFile = compressFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setSource(PlexusIoResource source) {
        this.source = source;
    }

    public PlexusIoResource getSource() {
        return this.source;
    }

    private void compressFile(InputStream in, OutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    protected void compress(PlexusIoResource resource, OutputStream zOut) throws IOException {
        try (BufferedInputStream in = Streams.bufferedInputStream(resource.getContents());){
            this.compressFile(in, zOut);
        }
    }

    public abstract void compress() throws ArchiverException;

    public abstract void close() throws ArchiverException;
}

