/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.composite;

import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import firtoolresolver.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import firtoolresolver.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import java.util.Properties;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValueInterpolated = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValueInterpolated != null) {
            return retValueInterpolated;
        }
        String element = configuration.getName();
        Properties retValue = new Properties();
        PlexusConfiguration[] children = configuration.getChildren("property");
        if (children != null && children.length > 0) {
            for (PlexusConfiguration child : children) {
                this.addEntry(retValue, element, child, expressionEvaluator);
            }
        }
        return retValue;
    }

    private void addEntry(Properties properties, String element, PlexusConfiguration property, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        Object name = this.fromExpression(property.getChild("name"), expressionEvaluator);
        if (name == null) {
            String msg = "Trying to convert the configuration element: '" + element + "', missing child element 'name' for property.";
            throw new ComponentConfigurationException(msg);
        }
        Object value = this.fromExpression(property.getChild("value"), expressionEvaluator);
        if (value == null) {
            properties.setProperty(name.toString(), "");
        } else {
            properties.setProperty(name.toString(), value.toString());
        }
    }
}

