/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.components.io.resources;

import firtoolresolver.shaded.org.codehaus.plexus.components.io.filemappers.FileMapper;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.filemappers.PrefixFileMapper;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.fileselectors.FileSelector;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.ClosingInputStream;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.Deferred;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nonnull;

public abstract class AbstractPlexusIoResourceCollection
implements PlexusIoResourceCollection {
    public static final InputStreamTransformer identityTransformer = new IdentityTransformer();
    private String prefix;
    private String[] includes;
    private String[] excludes;
    private FileSelector[] fileSelectors;
    private boolean caseSensitive = true;
    private boolean usingDefaultExcludes = true;
    private boolean includingEmptyDirectories = true;
    private FileMapper[] fileMappers;
    private InputStreamTransformer streamTransformer = identityTransformer;

    protected AbstractPlexusIoResourceCollection() {
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setFileSelectors(FileSelector[] fileSelectors) {
        this.fileSelectors = fileSelectors;
    }

    public FileSelector[] getFileSelectors() {
        return this.fileSelectors;
    }

    public void setStreamTransformer(InputStreamTransformer streamTransformer) {
        this.streamTransformer = streamTransformer == null ? identityTransformer : streamTransformer;
    }

    protected InputStreamTransformer getStreamTransformer() {
        return this.streamTransformer;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setUsingDefaultExcludes(boolean usingDefaultExcludes) {
        this.usingDefaultExcludes = usingDefaultExcludes;
    }

    public boolean isUsingDefaultExcludes() {
        return this.usingDefaultExcludes;
    }

    public void setIncludingEmptyDirectories(boolean includingEmptyDirectories) {
        this.includingEmptyDirectories = includingEmptyDirectories;
    }

    public boolean isIncludingEmptyDirectories() {
        return this.includingEmptyDirectories;
    }

    protected boolean isSelected(PlexusIoResource plexusIoResource) throws IOException {
        FileSelector[] fileSelectors = this.getFileSelectors();
        if (fileSelectors != null) {
            for (FileSelector fileSelector : fileSelectors) {
                if (fileSelector.isSelected(plexusIoResource)) continue;
                return false;
            }
        }
        return true;
    }

    public FileMapper[] getFileMappers() {
        return this.fileMappers;
    }

    public void setFileMappers(FileMapper[] fileMappers) {
        this.fileMappers = fileMappers;
    }

    @Override
    public Iterator<PlexusIoResource> iterator() {
        try {
            return this.getResources();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName(PlexusIoResource resource) {
        return this.getName(resource.getName());
    }

    protected String getName(String resourceName) {
        String name = resourceName;
        FileMapper[] mappers = this.getFileMappers();
        if (mappers != null) {
            for (FileMapper mapper : mappers) {
                name = mapper.getMappedFileName(name);
            }
        }
        return PrefixFileMapper.getMappedFileName(this.getPrefix(), name);
    }

    @Override
    public InputStream getInputStream(PlexusIoResource resource) throws IOException {
        InputStream contents = resource.getContents();
        return new ClosingInputStream(this.streamTransformer.transform(resource, contents), contents);
    }

    @Override
    public PlexusIoResource resolve(PlexusIoResource resource) throws IOException {
        Deferred deferred = new Deferred(resource, this, this.streamTransformer != identityTransformer);
        return deferred.asResource();
    }

    @Override
    public long getLastModified() throws IOException {
        long lastModified = 0L;
        Iterator<PlexusIoResource> iter = this.getResources();
        while (iter.hasNext()) {
            PlexusIoResource res = iter.next();
            long l = res.getLastModified();
            if (l == 0L) {
                return 0L;
            }
            if (lastModified != 0L && l <= lastModified) continue;
            lastModified = l;
        }
        return lastModified;
    }

    static class IdentityTransformer
    implements InputStreamTransformer {
        IdentityTransformer() {
        }

        @Override
        @Nonnull
        public InputStream transform(@Nonnull PlexusIoResource resource, @Nonnull InputStream inputStream) throws IOException {
            return inputStream;
        }
    }
}

