/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver.shaded.org.codehaus.plexus.components.io.resources;

import firtoolresolver.shaded.org.apache.commons.io.IOUtils;
import firtoolresolver.shaded.org.apache.commons.io.output.DeferredFileOutputStream;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.functions.ContentSupplier;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.functions.NameSupplier;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.functions.SizeSupplier;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import firtoolresolver.shaded.org.codehaus.plexus.components.io.resources.proxy.ProxyFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

class Deferred
implements ContentSupplier,
NameSupplier,
SizeSupplier {
    final DeferredFileOutputStream dfos;
    final PlexusIoResource resource;
    final PlexusIoResourceCollection owner;

    public Deferred(PlexusIoResource resource, PlexusIoResourceCollection owner, boolean hasTransformer) throws IOException {
        this.resource = resource;
        this.owner = owner;
        DeferredFileOutputStream deferredFileOutputStream = this.dfos = hasTransformer ? new DeferredFileOutputStream(5000000, "p-archiver", null, null) : null;
        if (this.dfos != null) {
            InputStream inputStream = owner.getInputStream(resource);
            IOUtils.copy(inputStream, (OutputStream)this.dfos);
            IOUtils.closeQuietly(inputStream);
        }
    }

    @Override
    @Nonnull
    public InputStream getContents() throws IOException {
        if (this.dfos == null) {
            return this.resource.getContents();
        }
        if (this.dfos.isInMemory()) {
            return new ByteArrayInputStream(this.dfos.getData());
        }
        return new FileInputStream(this.dfos.getFile()){

            @Override
            public void close() throws IOException {
                super.close();
                Deferred.this.dfos.getFile().delete();
            }
        };
    }

    @Override
    public long getSize() {
        if (this.dfos == null) {
            return this.resource.getSize();
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getByteCount();
        }
        return this.dfos.getFile().length();
    }

    @Override
    public String getName() {
        return this.owner.getName(this.resource);
    }

    public PlexusIoResource asResource() {
        return ProxyFactory.createProxy(this.resource, this);
    }
}

