/*
 * Decompiled with CFR 0.152.
 */
package firtoolresolver;

import coursier.Fetch;
import coursier.Fetch$;
import coursier.core.Dependency;
import coursier.core.Extension$;
import coursier.core.Module;
import coursier.package;
import dev.dirs.ProjectDirectories;
import firtoolresolver.FirtoolBinary;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import os.CommandResult;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.ProcessInput;
import os.ProcessOutput;
import os.ReadablePath;
import os.ResourcePath;
import os.ResourceRoot$;
import os.SegmentedPath;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.exists$;
import os.makeDir;
import os.proc;
import os.read;
import os.read$;
import os.write$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import scribe.Level;
import scribe.Level$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.Logger;
import scribe.Logger$;
import scribe.format.Formatter;
import scribe.format.Formatter$;
import scribe.handler.LogHandle;
import scribe.mdc.MDC$;
import scribe.output.format.OutputFormat;
import scribe.writer.Writer;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class Resolve$ {
    public static final Resolve$ MODULE$ = new Resolve$();
    private static Either<String, String> operatingSystem;
    private static Either<String, String> architecture;
    private static final Regex firtoolresolver$Resolve$$VersionRegex;
    private static volatile byte bitmap$0;

    static {
        firtoolresolver$Resolve$$VersionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^CIRCT firtool-(\\S+)$"));
    }

    private Either<String, String> operatingSystem$lzycompute() {
        Resolve$ resolve$ = this;
        synchronized (resolve$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                String osName = System.getProperty("os.name");
                String name = osName.toLowerCase();
                operatingSystem = name.startsWith("win") ? package$.MODULE$.Right().apply((Object)"windows") : (name.startsWith("mac") ? package$.MODULE$.Right().apply((Object)"macos") : (name.startsWith("linux") ? package$.MODULE$.Right().apply((Object)"linux") : package$.MODULE$.Left().apply((Object)new StringBuilder(16).append("Unsupported OS: ").append(osName).toString())));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return operatingSystem;
    }

    private Either<String, String> operatingSystem() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.operatingSystem$lzycompute();
        }
        return operatingSystem;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Either<String, String> architecture$lzycompute() {
        block5: {
            var1_1 = this;
            synchronized (var1_1) {
                if ((byte)(Resolve$.bitmap$0 & 2) != 0) break block5;
                osArch = System.getProperty("os.arch");
                v0 = arch = osArch.toLowerCase();
                var4_4 = "amd64";
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = arch;
                var5_5 = "x86_64";
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 /* !! */  = package$.MODULE$.Right().apply((Object)"x64");
                } else {
                    v3 = arch;
                    var6_6 = "aarch64";
                    v2 /* !! */  = !(v3 != null ? v3.equals(var6_6) == false : var6_6 != null) ? package$.MODULE$.Right().apply((Object)"aarch64") : package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Unsupported architecture: ").append(osArch).toString());
                }
                Resolve$.architecture = v2 /* !! */ ;
                Resolve$.bitmap$0 = (byte)(Resolve$.bitmap$0 | 2);
            }
        }
        return Resolve$.architecture;
    }

    private Either<String, String> architecture() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.architecture$lzycompute();
        }
        return architecture;
    }

    private String groupId() {
        return "org.chipsalliance";
    }

    private String artId() {
        return "llvm-firtool";
    }

    private String appleSiliconFixup(Logger logger, String os, String arch) {
        String string = os;
        String string2 = "macos";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = arch;
            String string4 = "aarch64";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Using x64 architecture for Apple silicon")}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("appleSiliconFixup"), new Line(53), MDC$.MODULE$.instance());
                return "x64";
            }
        }
        return arch;
    }

    private Either<String, String> determinePlatform(Logger logger) {
        return this.operatingSystem().flatMap((Function1 & Serializable)os -> MODULE$.architecture().map((Function1 & Serializable)_arch -> {
            String arch = MODULE$.appleSiliconFixup(logger, (String)os, (String)_arch);
            return new Tuple2(_arch, (Object)arch);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String arch = (String)tuple2._2();
                return new StringBuilder(1).append((String)os).append("-").append(arch).toString();
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private String binaryName() {
        return "firtool";
    }

    public Regex firtoolresolver$Resolve$$VersionRegex() {
        return firtoolresolver$Resolve$$VersionRegex;
    }

    private String cacheDir() {
        String path = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"FIRTOOL_CACHE", (Function0 & Serializable)() -> ProjectDirectories.from((String)"", (String)Resolve$.MODULE$.groupId(), (String)Resolve$.MODULE$.artId()).cacheDir);
        return new File(path).getAbsolutePath();
    }

    private Either<String, Either<String, FirtoolBinary>> checkFirtoolPath(Logger logger) {
        Try result;
        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Checking FIRTOOL_PATH for firtool")}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(81), MDC$.MODULE$.instance());
        Option firtoolPathOpt = scala.sys.package$.MODULE$.env().get((Object)"FIRTOOL_PATH");
        if (firtoolPathOpt.isEmpty()) {
            String msg = "FIRTOOL_PATH not set";
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(87), MDC$.MODULE$.instance());
            return Resolve$.Recoverable$1(msg);
        }
        Path firtoolPath = Path$.MODULE$.apply(firtoolPathOpt.get(), os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
        if (!exists$.MODULE$.apply(firtoolPath)) {
            String msg = new StringBuilder(30).append("FIRTOOL_PATH (").append(firtoolPath).append(") does not exist").toString();
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(94), MDC$.MODULE$.instance());
            return Resolve$.Unrecoverable$1(msg);
        }
        Path binary = firtoolPath.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(this.binaryName()));
        proc proc2 = new proc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(binary), Shellable$.MODULE$.StringShellable("--version")}));
        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(9).append("Running: ").append(proc2.commandChunks().mkString(" ")).toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(101), MDC$.MODULE$.instance());
        Try try_ = result = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            boolean x$1 = true;
            boolean x$2 = false;
            Path x$3 = proc2.call$default$1();
            Map x$4 = proc2.call$default$2();
            ProcessInput x$5 = proc2.call$default$3();
            ProcessOutput x$6 = proc2.call$default$4();
            ProcessOutput x$7 = proc2.call$default$5();
            long x$8 = proc2.call$default$7();
            boolean x$9 = proc2.call$default$9();
            return proc2.call(x$3, x$4, x$5, x$6, x$7, true, x$8, false, x$9);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            String msg = err.getMessage();
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(107), MDC$.MODULE$.instance());
            return Resolve$.Unrecoverable$1(msg);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CommandResult result2 = (CommandResult)success.value();
            Option version = result2.out().lines().collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = Resolve$.MODULE$.firtoolresolver$Resolve$$VersionRegex().unapplySeq(A1)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String v = (String)((LinearSeqOps)option.get()).apply(0);
                        return (B1)v;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(String x1) {
                    Option option;
                    String string = x1;
                    return string != null && !(option = Resolve$.MODULE$.firtoolresolver$Resolve$$VersionRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0;
                }
            });
            if (result2.exitCode() != 0) {
                String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(111).append("|Unable to run firtool binary (").append(binary).append("):\n                |  Exit Code: ").append(result2.exitCode()).append("\n                |  Output: '").append(result2.out().text()).append("\n                |").toString()));
                logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkFirtoolPath"), new Line(118), MDC$.MODULE$.instance());
                return Resolve$.Unrecoverable$1(msg);
            }
            String v = (String)version.getOrElse((Function0 & Serializable)() -> "<unknown>");
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Right().apply((Object)new FirtoolBinary(binary.toIO(), v)));
        }
        throw new MatchError((Object)try_);
    }

    private Either<String, FirtoolBinary> checkResources(Option<URLClassLoader> classloader, Logger logger) {
        File destFile;
        String version;
        block9: {
            Either<String, String> platform = this.determinePlatform(logger);
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Checking resources for firtool")}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(130), MDC$.MODULE$.instance());
            if (platform.isLeft()) {
                logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> (String)Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(platform)))}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(132), MDC$.MODULE$.instance());
                return package$.MODULE$.Left().apply(Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(platform)));
            }
            ResourcePath resources = (ResourcePath)classloader.map((Function1 & Serializable)x$2 -> os.package$.MODULE$.resource(ResourceRoot$.MODULE$.classLoaderResourceRoot((ClassLoader)x$2))).getOrElse((Function0 & Serializable)() -> os.package$.MODULE$.resource(os.package$.MODULE$.resource$default$1()));
            ResourcePath baseDir = (ResourcePath)((SegmentedPath)resources.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(this.groupId()))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(this.artId()));
            ResourcePath artDir = (ResourcePath)baseDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk((String)platform.toOption().get()));
            ResourcePath versionFile = (ResourcePath)baseDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("project.version"));
            Option versionOpt = Try$.MODULE$.apply((Function0 & Serializable)() -> read$.MODULE$.apply((ReadablePath)versionFile)).toOption();
            if (versionOpt.isEmpty()) {
                String msg = new StringBuilder(41).append("firtool version not found in resources (").append(versionFile).append(")").toString();
                logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(142), MDC$.MODULE$.instance());
                return package$.MODULE$.Left().apply((Object)msg);
            }
            version = (String)versionOpt.get();
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(35).append("Firtool version ").append(version).append(" found in resources").toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(147), MDC$.MODULE$.instance());
            Path topDir = Path$.MODULE$.apply((Object)this.cacheDir(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(version));
            Path destDir = topDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("bin"));
            Path destBin = destDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("firtool"));
            destFile = destBin.toIO();
            Resolve$ resolve$ = this;
            synchronized (resolve$) {
                Left left;
                block8: {
                    if (destFile.isFile()) {
                        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(30).append("Firtool binary ").append(destFile).append(" already exists").toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(159), MDC$.MODULE$.instance());
                    } else {
                        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(34).append("Copying firtool from resources to ").append(destFile).toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(162), MDC$.MODULE$.instance());
                        ResourcePath resourceBin = (ResourcePath)((SegmentedPath)artDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("bin"))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("firtool"));
                        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                            makeDir.all$.MODULE$.apply(destDir);
                            write$.MODULE$.apply(destBin, (Source)Source$.MODULE$.WritableSource((Object)read.stream$.MODULE$.apply((ReadablePath)resourceBin), Predef$.MODULE$.$conforms()), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
                            destFile.setWritable(true);
                            destFile.setReadable(true);
                            return destFile.setExecutable(true);
                        });
                        if (result.isFailure()) {
                            String msg = new StringBuilder(28).append("Copying firtool failed with ").append(result.failed().get()).toString();
                            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("checkResources"), new Line(174), MDC$.MODULE$.instance());
                            left = package$.MODULE$.Left().apply((Object)msg);
                            break block8;
                        }
                    }
                    break block9;
                }
                return left;
            }
        }
        return package$.MODULE$.Right().apply((Object)new FirtoolBinary(destFile, version));
    }

    private Either<String, FirtoolBinary> fetchArtifact(Logger logger, String defaultVersion) {
        Either<String, String> either = this.determinePlatform(logger);
        if (either instanceof Left) {
            Left left = (Left)either;
            String msg = (String)left.value();
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("platform"), new Line(186), MDC$.MODULE$.instance());
            return package$.MODULE$.Left().apply((Object)msg);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        String name = (String)right.value();
        String platform = name;
        String org = coursier.package$.MODULE$.Organization().apply(this.groupId());
        Module module = package.Module$.MODULE$.apply(org, coursier.package$.MODULE$.ModuleName().apply(String.valueOf(this.artId())), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        Dependency dep = package.Dependency$.MODULE$.apply(module, defaultVersion).withPublication("", coursier.package$.MODULE$.Type().empty(), Extension$.MODULE$.empty(), coursier.package$.MODULE$.Classifier().apply(platform));
        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(32).append("Attempting to fetch ").append(dep.module()).append(":").append(dep.version()).append(",clasifier=").append(platform).toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("fetchArtifact"), new Line(198), MDC$.MODULE$.instance());
        Try resolution = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Fetch qual$1 = Fetch$.MODULE$.FetchTaskOps(Fetch$.MODULE$.apply().addDependencies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Dependency[]{dep})));
            ExecutionContext x$1 = Fetch.FetchTaskOps$.MODULE$.run$default$1$extension(qual$1);
            return Fetch.FetchTaskOps$.MODULE$.run$extension(qual$1, x$1);
        });
        if (resolution.isFailure()) {
            String msg = new StringBuilder(1).append(((Throwable)resolution.failed().get()).toString()).append("\n").toString();
            logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> msg)}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("fetchArtifact"), new Line(207), MDC$.MODULE$.instance());
            return package$.MODULE$.Left().apply((Object)msg);
        }
        File jar = (File)((IterableOps)resolution.get()).head();
        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(21).append("Successfully fetched ").append(jar).toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("fetchArtifact"), new Line(212), MDC$.MODULE$.instance());
        logger.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(32).append("Loading ").append(jar).append(" to search its resources").toString())}), new Pkg("firtoolresolver"), new FileName("Main.scala"), new Name("fetchArtifact"), new Line(215), MDC$.MODULE$.instance());
        URLClassLoader classloader = new URLClassLoader((URL[])((Object[])new URL[]{jar.toURL()}));
        return this.checkResources((Option<URLClassLoader>)new Some((Object)classloader), logger);
    }

    public Either<String, FirtoolBinary> apply(String defaultVersion, boolean verbose) {
        Level level = verbose ? Level$.MODULE$.Debug() : Level$.MODULE$.Warn();
        Logger qual$1 = Logger$.MODULE$.apply("FirtoolResolver");
        Formatter x$1 = Formatter$.MODULE$.enhanced();
        Writer x$2 = qual$1.withHandler$default$2();
        Option x$3 = qual$1.withHandler$default$3();
        List x$4 = qual$1.withHandler$default$4();
        OutputFormat x$5 = qual$1.withHandler$default$5();
        LogHandle x$6 = qual$1.withHandler$default$6();
        Logger logger = qual$1.withHandler(x$1, x$2, x$3, x$4, x$5, x$6).withMinimumLevel(level);
        return this.apply(logger, defaultVersion);
    }

    public Either<String, FirtoolBinary> apply(Logger logger, String defaultVersion) {
        return this.checkFirtoolPath(logger).flatMap((Function1 & Serializable)res -> res.left().flatMap((Function1 & Serializable)msg1 -> MODULE$.checkResources((Option<URLClassLoader>)None$.MODULE$, logger).left().flatMap((Function1 & Serializable)msg2 -> MODULE$.fetchArtifact(logger, defaultVersion).left().map((Function1 & Serializable)msg3 -> new StringBuilder(27).append("Failed to fetch firtool:\n").append((String)msg1).append("\n").append((String)msg2).append("\n").append((String)msg3).toString()))));
    }

    public boolean apply$default$2() {
        return false;
    }

    private static final Either Recoverable$1(String msg) {
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)msg));
    }

    private static final Either Unrecoverable$1(String msg) {
        return package$.MODULE$.Left().apply((Object)msg);
    }

    private Resolve$() {
    }
}

