package org.chrisjaehnen.openlib.testutils.exception;

import junit.framework.AssertionFailedError;
import org.junit.Test;

import static junit.framework.TestCase.assertTrue;

public class TestExpectedThrownException
{
    @Test
    public void testExpectedExceptionIsThrown()
    {
        // setup
        // N/A

        // execute
        new ExpectedThrownException(IllegalArgumentException.class)
        {
            @Override
            protected void execute()
            {
                throw new IllegalArgumentException();
            }
        }.executeTest();

        // assert
        // see expected exception
    }

    @Test
    public void testExpectedExceptionIsNotThrownAndTestFails()
    {
        // setup
        // N/A

        // execute
        try
        {
            new ExpectedThrownException(IllegalArgumentException.class)
            {
                @Override
                protected void execute()
                {
                }
            }.executeTest();
        }
        catch (AssertionFailedError e)
        {
            assertTrue(String.format("Expected exception was not thrown '%s'", e.getClass().getName()), true);
        }

        // assert
        // see expected exception
    }

    @Test
    public void testUnexpectedExceptionIsThrownAndTestFails()
    {
        // setup
        // N/A

        // execute
        try
        {
            new ExpectedThrownException(IllegalArgumentException.class)
            {
                @Override
                protected void execute()
                {
                    throw new RuntimeException();
                }
            }.executeTest();
        }
        catch (AssertionFailedError e)
        {
            assertTrue(String.format("Unexpected exception was thrown '%s'", e.getClass().getName()), true);
        }

        // assert
        // see expected exception
    }
}
