/*
 * Decompiled with CFR 0.152.
 */
package org.chrisjaehnen.openlib.testutils.exception;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.chrisjaehnen.openlib.testutils.exception.ExpectedThrownException;
import org.junit.Test;

public class TestExpectedThrownException {
    @Test
    public void testExpectedExceptionIsThrown() {
        new ExpectedThrownException(IllegalArgumentException.class){

            protected void execute() {
                throw new IllegalArgumentException();
            }
        }.executeTest();
    }

    @Test
    public void testExpectedExceptionIsNotThrownAndTestFails() {
        try {
            new ExpectedThrownException(IllegalArgumentException.class){

                protected void execute() {
                }
            }.executeTest();
        }
        catch (AssertionFailedError e) {
            TestCase.assertTrue((String)String.format("Expected exception was not thrown '%s'", ((Object)((Object)e)).getClass().getName()), (boolean)true);
        }
    }

    @Test
    public void testUnexpectedExceptionIsThrownAndTestFails() {
        try {
            new ExpectedThrownException(IllegalArgumentException.class){

                protected void execute() {
                    throw new RuntimeException();
                }
            }.executeTest();
        }
        catch (AssertionFailedError e) {
            TestCase.assertTrue((String)String.format("Unexpected exception was thrown '%s'", ((Object)((Object)e)).getClass().getName()), (boolean)true);
        }
    }
}

