/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.util.List;
import org.chromattic.apt.FormatterStyle;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.WildcardTypeInfo;

public class TypeFormatter {
    private final ClassTypeInfo context;
    private final FormatterStyle style;
    private final StringBuilder s;

    public TypeFormatter(ClassTypeInfo context, FormatterStyle style, StringBuilder s) {
        this.context = context;
        this.style = style;
        this.s = s;
    }

    public void format(TypeInfo ti) {
        this.format(ti, false);
    }

    private void format(TypeInfo ti, boolean fromArray) {
        if (ti instanceof ClassTypeInfo) {
            this.format((ClassTypeInfo)ti, fromArray);
        } else if (ti instanceof ParameterizedTypeInfo) {
            this.format((ParameterizedTypeInfo)ti, fromArray);
        } else if (ti instanceof TypeVariableInfo) {
            this.format((TypeVariableInfo)ti, fromArray);
        } else if (ti instanceof ArrayTypeInfo) {
            this.format((ArrayTypeInfo)ti, fromArray);
        } else if (ti instanceof WildcardTypeInfo) {
            this.format((WildcardTypeInfo)ti, fromArray);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void format(ClassTypeInfo cti, boolean fromArray) {
        if (cti instanceof VoidTypeInfo) {
            switch (this.style) {
                case CAST: 
                case TYPE_PARAMETER: {
                    throw new AssertionError();
                }
                case RETURN_TYPE: 
                case LITERAL: {
                    this.s.append("void");
                }
            }
        } else {
            block4 : switch (this.style) {
                case CAST: {
                    if (!fromArray) {
                        if (cti instanceof SimpleTypeInfo) {
                            switch (((SimpleTypeInfo)cti).getLiteralType()) {
                                case INT: {
                                    this.s.append("java.lang.Integer");
                                    break block4;
                                }
                                case BOOLEAN: {
                                    this.s.append("java.lang.Boolean");
                                    break block4;
                                }
                                case LONG: {
                                    this.s.append("java.lang.Long");
                                    break block4;
                                }
                                case DOUBLE: {
                                    this.s.append("java.lang.Double");
                                    break block4;
                                }
                                case FLOAT: {
                                    this.s.append("java.lang.Float");
                                    break block4;
                                }
                            }
                            throw new UnsupportedOperationException();
                        }
                        this.s.append(cti.getName());
                        break;
                    }
                    this.s.append(cti.getName());
                    break;
                }
                case TYPE_PARAMETER: 
                case RETURN_TYPE: 
                case LITERAL: {
                    this.s.append(cti.getName());
                }
            }
        }
    }

    private void format(ParameterizedTypeInfo pti, boolean fromArray) {
        TypeInfo rawType = pti.getRawType();
        this.format(rawType);
    }

    private void format(TypeVariableInfo tvi, boolean fromArray) {
        switch (this.style) {
            case CAST: 
            case TYPE_PARAMETER: 
            case RETURN_TYPE: 
            case LITERAL: {
                TypeInfo resolved = this.context.resolve((TypeInfo)tvi);
                if (resolved instanceof TypeVariableInfo) {
                    TypeVariableInfo resolvedTVI = (TypeVariableInfo)resolved;
                    List bounds = resolvedTVI.getBounds();
                    if (bounds.size() != 1) {
                        throw new UnsupportedOperationException("Need to add support for multiple bounds");
                    }
                    TypeInfo bound = (TypeInfo)bounds.get(0);
                    this.format(bound);
                    break;
                }
                this.format(resolved);
                break;
            }
        }
    }

    private void format(ArrayTypeInfo ati, boolean fromArray) {
        switch (this.style) {
            case CAST: 
            case TYPE_PARAMETER: 
            case RETURN_TYPE: 
            case LITERAL: {
                TypeInfo componentTI = ati.getComponentType();
                this.format(componentTI, true);
                this.s.append("[]");
                break;
            }
        }
    }

    private void format(WildcardTypeInfo wti, boolean fromArray) {
    }
}

