/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.apt.FormatterStyle;
import org.chromattic.apt.Instrumented;
import org.chromattic.apt.Invoker;
import org.chromattic.apt.TypeFormatter;
import org.chromattic.spi.instrument.MethodHandler;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;
import org.reflext.apt.JavaxLangMethodModel;
import org.reflext.apt.JavaxLangTypeModel;
import org.reflext.core.TypeDomain;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.chromattic.api.annotations.PrimaryType", "org.chromattic.api.annotations.MixinType"})
public class ChromatticProcessor
extends AbstractProcessor {
    private final TypeDomain<Object, ExecutableElement> domain = new TypeDomain((TypeModel)new JavaxLangTypeModel(), (MethodModel)new JavaxLangMethodModel());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.process(roundEnv, PrimaryType.class);
        this.process(roundEnv, MixinType.class);
        return true;
    }

    private void process(RoundEnvironment roundEnv, Class<? extends Annotation> annotationClass) {
        Set<? extends Element> elts = roundEnv.getElementsAnnotatedWith(annotationClass);
        for (Element element : elts) {
            TypeElement typeElt = (TypeElement)element;
            ClassTypeInfo cti = (ClassTypeInfo)this.domain.getType((Object)typeElt);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "About to process the type " + cti.getName());
            Filer filer = this.processingEnv.getFiler();
            try {
                JavaFileObject jfo = filer.createSourceFile(typeElt.getQualifiedName() + "_Chromattic", typeElt);
                PrintWriter out = new PrintWriter(jfo.openWriter());
                StringBuilder builder = new StringBuilder();
                this.writeClass(roundEnv, builder, cti);
                out.write(builder.toString());
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeClass(RoundEnvironment roundEnv, StringBuilder out, ClassTypeInfo cti) {
        String simpleClassName = cti.getSimpleName() + "_Chromattic";
        out.append("package ").append(cti.getPackageName()).append(";\n");
        out.append("import ").append(Invoker.class.getName()).append(";\n");
        out.append("import ").append(Instrumented.class.getName()).append(";\n");
        StringBuffer sb = new StringBuffer("public class ");
        sb.append(simpleClassName);
        sb.append(" extends ");
        if (cti.getKind() == ClassKind.INTERFACE) {
            sb.append(Object.class.getName());
            sb.append(" implements ");
            sb.append(cti.getSimpleName());
            sb.append(",");
            sb.append(Instrumented.class.getSimpleName());
        } else {
            sb.append(cti.getSimpleName());
            sb.append(" implements ");
            sb.append(Instrumented.class.getSimpleName());
        }
        sb.append(" {\n");
        out.append(sb.toString());
        this.appendContructor(roundEnv, out, cti);
        this.appendAbstractMethods(simpleClassName, roundEnv, out, cti);
        out.append("}\n");
    }

    private void appendContructor(RoundEnvironment roundEnv, StringBuilder out, ClassTypeInfo cti) {
        out.append("public final ").append(MethodHandler.class.getName()).append(" handler;\n");
        out.append("public ").append(cti.getSimpleName()).append("_Chromattic(").append(MethodHandler.class.getName()).append(" handler) {\n");
        out.append("this.handler = handler;\n");
        out.append("}\n");
    }

    private Iterable<MethodInfo> getMethodsToImplement(ClassTypeInfo cti) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL, true);
        for (MethodInfo method : introspector.getMethods((TypeInfo)cti)) {
            if (!method.isAbstract()) continue;
            methods.add(method);
        }
        return methods;
    }

    private void appendAbstractMethods(String simpleClassName, RoundEnvironment roundEnv, StringBuilder out, ClassTypeInfo cti) {
        int id = 0;
        Iterable<MethodInfo> methods = this.getMethodsToImplement(cti);
        for (MethodInfo method : methods) {
            String scope;
            String methodId = "method_" + id++;
            String methodName = method.getName();
            List parameterTypes = method.getParameterTypes();
            TypeInfo rti = method.getReturnType();
            switch (method.getAccess()) {
                case PACKAGE_PROTECTED: {
                    scope = "";
                    break;
                }
                case PROTECTED: {
                    scope = "protected";
                    break;
                }
                case PUBLIC: {
                    scope = "public";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            out.append("private static final ").append(Invoker.class.getSimpleName()).append(" ").append(methodId).append(" = ").append(Invoker.class.getSimpleName()).append(".getDeclaredMethod(").append(method.getOwner().getName()).append(".class,").append('\"').append(methodName).append('\"');
            for (TypeInfo parameterType : parameterTypes) {
                out.append(",");
                new TypeFormatter(cti, FormatterStyle.LITERAL, out).format(parameterType);
                out.append(".class");
            }
            out.append(");\n");
            out.append(scope).append(" ");
            new TypeFormatter(cti, FormatterStyle.RETURN_TYPE, out).format(rti);
            out.append(" ").append(methodName).append("(");
            StringBuffer sb1 = new StringBuffer("Object[] args = new Object[]{");
            for (int i = 0; i < parameterTypes.size(); ++i) {
                TypeInfo parameterType = (TypeInfo)parameterTypes.get(i);
                if (i > 0) {
                    out.append(",");
                    sb1.append(",");
                }
                new TypeFormatter(cti, FormatterStyle.TYPE_PARAMETER, out).format(parameterType);
                out.append(" arg_").append(i);
                sb1.append("arg_").append(i);
            }
            sb1.append("};\n");
            out.append(") {\n");
            out.append(sb1.toString());
            if (rti instanceof VoidTypeInfo) {
                out.append(methodId).append(".invoke(handler, this, args);");
            } else {
                out.append("return (");
                new TypeFormatter(cti, FormatterStyle.CAST, out).format(rti);
                out.append(")").append(methodId).append(".invoke(handler, this, args);");
            }
            out.append("}\n");
        }
    }
}

