/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math;

public final class MathFunctions {
    private static final double[] STIRLING_EXPANSION_LN_GAMMA = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
    private static final double[] POLY_APPROX_2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
    private static final double[] POLY_APPROX_3 = new double[]{1.0, -351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};

    private MathFunctions() {
    }

    public static double pow(double a, int b) {
        if (b >= 0) {
            double c = 1.0;
            while (b > 0) {
                if ((b & 1) == 1) {
                    c *= a;
                }
                b >>= 1;
                a *= a;
            }
            return c;
        }
        return 1.0 / MathFunctions.pow(a, -b);
    }

    public static double logGamma(double n) {
        if (!Double.isFinite(n)) {
            return n;
        }
        if (n >= 2.556348E305) {
            return Double.POSITIVE_INFINITY;
        }
        if (n <= -2.556348E305) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n < -34.0) {
            double p = (int)(n = -n);
            if (p == n) {
                return Double.POSITIVE_INFINITY;
            }
            double z = n - p;
            if (z > 0.5) {
                z = (p += 1.0) - n;
            }
            if ((z = n * Math.sin(z * Math.PI)) == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            double LOG_PI = 1.1447298858494002;
            return 1.1447298858494002 - Math.log(z) - MathFunctions.logGamma(n);
        }
        if (n < 13.0) {
            double z = 1.0;
            int p = 0;
            double u = n;
            while (u >= 3.0) {
                u = n + (double)(--p);
                z *= u;
            }
            while (u < 2.0) {
                if (u == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                z /= u;
                u = n + (double)(++p);
            }
            if (z < 0.0) {
                z = -z;
            }
            if (u == 2.0) {
                return Math.log(z);
            }
            return Math.log(z) + (n += (double)(p -= 2)) * MathFunctions.evaluatePolynomial(n, POLY_APPROX_2) / MathFunctions.evaluatePolynomial(n, POLY_APPROX_3);
        }
        double LOG_SQRT_PI2 = 0.9189385332046728;
        double q = (n - 0.5) * Math.log(n) - n + 0.9189385332046728;
        if (n > 1.0E8) {
            return q;
        }
        double p = 1.0 / (n * n);
        q = n >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / n) : (q += MathFunctions.evaluatePolynomial(p, STIRLING_EXPANSION_LN_GAMMA) / n);
        return q;
    }

    private static double evaluatePolynomial(double x, double[] polynomial) {
        double result = polynomial[0];
        for (int i = 1; i < polynomial.length; ++i) {
            result = result * x + polynomial[i];
        }
        return result;
    }
}

