/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public class BlockInterchangeDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int[] inv2 = p2.getInverse();
        int[] p = new int[inv2.length + 2];
        int[] inv = new int[p.length];
        boolean[] visited = new boolean[p.length];
        for (int i = 0; i < p1.length(); ++i) {
            int index = inv2[p1.get(i)] + 1;
            p[index] = i + 1;
            inv[i + 1] = index;
        }
        inv[0] = 0;
        p[0] = 0;
        int n = p.length - 1;
        inv[p.length - 1] = n;
        p[p.length - 1] = n;
        int cycles = 0;
        for (int i = 0; i <= p1.length(); ++i) {
            if (visited[i]) continue;
            ++cycles;
            int j = i;
            while (!visited[j]) {
                visited[j] = true;
                ++j;
                j = p[inv[j] - 1];
            }
        }
        return (p1.length() + 1 - cycles) / 2;
    }

    @Override
    public int max(int length) {
        return length >> 1;
    }
}

