/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import java.util.Arrays;
import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class KendallTauDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int n = p2.length();
        int[] invP1 = p1.getInverse();
        int[] arrayP2 = new int[n];
        for (int i = 0; i < n; ++i) {
            arrayP2[i] = invP1[p2.get(i)];
        }
        return this.countInversions(arrayP2);
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length * (length - 1) >> 1;
    }

    private int countInversions(int[] array) {
        if (array.length <= 1) {
            return 0;
        }
        int m = array.length >> 1;
        int[] left = Arrays.copyOfRange(array, 0, m);
        int[] right = Arrays.copyOfRange(array, m, array.length);
        int count = this.countInversions(left) + this.countInversions(right);
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < left.length && j < right.length) {
            if (left[i] < right[j]) {
                array[k] = left[i];
                ++i;
                ++k;
                continue;
            }
            count += left.length - i;
            array[k] = right[j];
            ++j;
            ++k;
        }
        while (i < left.length) {
            array[k] = left[i];
            ++i;
            ++k;
        }
        while (j < right.length) {
            array[k] = right[j];
            ++j;
            ++k;
        }
        return count;
    }
}

