/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class LeeDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int L1 = p1.length();
        if (L1 <= 1) {
            return 0;
        }
        int distancePoints = 0;
        int[] invP1 = p1.getInverse();
        int[] invP2 = p2.getInverse();
        for (int i = 0; i < L1; ++i) {
            int dev = Math.abs(invP1[i] - invP2[i]);
            distancePoints += Math.min(dev, L1 - dev);
        }
        return distancePoints;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length * (length >> 1);
    }
}

