/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cicirello.sequences.distance.AbstractSequenceDistanceMeasurer;

public final class KendallTauSequenceDistance
extends AbstractSequenceDistanceMeasurer {
    private final boolean USE_HASHMAP;

    public KendallTauSequenceDistance() {
        this.USE_HASHMAP = true;
    }

    public KendallTauSequenceDistance(boolean useAlternateAlg) {
        this.USE_HASHMAP = !useAlternateAlg;
    }

    @Override
    public int distance(int[] s1, int[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(long[] s1, long[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(short[] s1, short[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(byte[] s1, byte[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(char[] s1, char[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(String s1, String s2) {
        if (s1.length() != s2.length()) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length() == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length()][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(float[] s1, float[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(double[] s1, double[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public int distance(Object[] s1, Object[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.USE_HASHMAP || !(s1 instanceof Comparable[]) ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements((Comparable[])s1, (Comparable[])s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    @Override
    public <T> int distance(List<T> s1, List<T> s2) {
        if (s1.size() != s2.size()) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.size() == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.size()][2];
        int numLabels = this.USE_HASHMAP || !(s1.get(0) instanceof Comparable) ? this.relabelElementsWithHash(s1, s2, relabeling) : this.relabelElements(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping);
    }

    private int[] mapElements(Bucket[][] buckets, int seqLength) {
        int[] mapping = new int[seqLength];
        for (int k = 0; k < buckets.length; ++k) {
            while (buckets[k][0].head != null) {
                int j;
                int i = buckets[k][0].remove();
                if (buckets[k][1].head == null) {
                    throw new IllegalArgumentException("Sequences must contain same elements.");
                }
                mapping[i] = j = buckets[k][1].remove();
            }
            if (buckets[k][1].head == null) continue;
            throw new IllegalArgumentException("Sequences must contain same elements.");
        }
        return mapping;
    }

    private Bucket[][] bucketSortElements(int[][] relabeling, int numLabels) {
        int i;
        Bucket[][] buckets = new Bucket[numLabels][2];
        for (i = 0; i < numLabels; ++i) {
            buckets[i][0] = new Bucket();
            buckets[i][1] = new Bucket();
        }
        for (i = 0; i < relabeling.length; ++i) {
            buckets[relabeling[i][0]][0].add(i);
            buckets[relabeling[i][1]][1].add(i);
        }
        return buckets;
    }

    private int relabelElementsWithHash(Object[] s1, Object[] s2, int[][] relabeling) {
        int i;
        HashMap<Object, Integer> labelMap = new HashMap<Object, Integer>((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = (Integer)labelMap.get(s1[i]);
            Integer j = (Integer)labelMap.get(s2[i]);
            if (j == null) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private <T> int relabelElementsWithHash(List<T> s1, List<T> s2, int[][] relabeling) {
        HashMap<T, Integer> labelMap = new HashMap<T, Integer>((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (T e : s1) {
            if (labelMap.containsKey(e)) continue;
            labelMap.put(e, ++current);
        }
        Iterator<T> iter1 = s1.iterator();
        Iterator<T> iter2 = s2.iterator();
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = (Integer)labelMap.get(iter1.next());
            Integer j = (Integer)labelMap.get(iter2.next());
            if (j == null) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(int[] s1, int[] s2, int[][] relabeling) {
        int i;
        IntHT labelMap = new IntHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(double[] s1, double[] s2, int[][] relabeling) {
        int i;
        DoubleHT labelMap = new DoubleHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(float[] s1, float[] s2, int[][] relabeling) {
        int i;
        DoubleHT labelMap = new DoubleHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(long[] s1, long[] s2, int[][] relabeling) {
        int i;
        LongHT labelMap = new LongHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(short[] s1, short[] s2, int[][] relabeling) {
        int i;
        ShortHT labelMap = new ShortHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(char[] s1, char[] s2, int[][] relabeling) {
        int i;
        CharHT labelMap = new CharHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(String s1, String s2, int[][] relabeling) {
        int i;
        CharHT labelMap = new CharHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1.charAt(i))) continue;
            labelMap.put(s1.charAt(i), ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1.charAt(i));
            int j = labelMap.get(s2.charAt(i));
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    private int relabelElementsWithHash(byte[] s1, byte[] s2, int[][] relabeling) {
        int i;
        int[] labelMap = new int[256];
        int current = 0;
        for (i = 0; i < relabeling.length; ++i) {
            int key = 0xFF & s1[i];
            if (labelMap[key] != 0) continue;
            labelMap[key] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int key1 = 0xFF & s1[i];
            relabeling[i][0] = labelMap[key1] - 1;
            int key2 = 0xFF & s2[i];
            int j = labelMap[key2];
            if (j == 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j - 1;
        }
        return current;
    }

    private int relabelElements(int[] s1, int[] s2, int[][] relabeling) {
        int i;
        int[] c1 = (int[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(long[] s1, long[] s2, int[][] relabeling) {
        int i;
        long[] c1 = (long[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(short[] s1, short[] s2, int[][] relabeling) {
        int i;
        short[] c1 = (short[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(byte[] s1, byte[] s2, int[][] relabeling) {
        int i;
        byte[] c1 = (byte[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(char[] s1, char[] s2, int[][] relabeling) {
        int i;
        char[] c1 = (char[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(String s1, String s2, int[][] relabeling) {
        int i;
        char[] c1 = s1.toCharArray();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1.charAt(i));
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2.charAt(i));
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(float[] s1, float[] s2, int[][] relabeling) {
        int i;
        float[] c1 = (float[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(double[] s1, double[] s2, int[][] relabeling) {
        int i;
        double[] c1 = (double[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(boolean[] s1, boolean[] s2, int[][] relabeling) {
        int i;
        int trueCount1 = 0;
        int trueCount2 = 0;
        for (i = 0; i < s1.length; ++i) {
            if (s1[i]) {
                ++trueCount1;
            }
            if (!s2[i]) continue;
            ++trueCount2;
        }
        if (trueCount1 != trueCount2) {
            throw new IllegalArgumentException("Sequences must contain same elements.");
        }
        if (trueCount1 < s1.length) {
            for (i = 0; i < relabeling.length; ++i) {
                relabeling[i][0] = s1[i] ? 1 : 0;
                relabeling[i][1] = s2[i] ? 1 : 0;
            }
        } else {
            for (i = 0; i < relabeling.length; ++i) {
                relabeling[i][1] = 0;
                relabeling[i][0] = 0;
            }
        }
        return trueCount1 > 0 && s1.length > trueCount1 ? 2 : 1;
    }

    private int relabelElements(Comparable[] s1, Comparable[] s2, int[][] relabeling) {
        int i;
        Object[] c1 = (Comparable[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int relabelElements(List<Comparable> s1, List<Comparable> s2, int[][] relabeling) {
        Object[] c1 = s1.toArray(new Comparable[s1.size()]);
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (int i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        Iterator<Comparable> iter1 = s1.iterator();
        Iterator<Comparable> iter2 = s2.iterator();
        for (int i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, iter1.next());
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, iter2.next());
            if (j < 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    private int countInversions(int[] array) {
        if (array.length <= 1) {
            return 0;
        }
        int m = array.length / 2;
        int[] left = Arrays.copyOfRange(array, 0, m);
        int[] right = Arrays.copyOfRange(array, m, array.length);
        int count = this.countInversions(left) + this.countInversions(right);
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < left.length && j < right.length) {
            if (left[i] <= right[j]) {
                array[k] = left[i];
                ++i;
                ++k;
                continue;
            }
            count += left.length - i;
            array[k] = right[j];
            ++j;
            ++k;
        }
        while (i < left.length) {
            array[k] = left[i];
            ++i;
            ++k;
        }
        while (j < right.length) {
            array[k] = right[j];
            ++j;
            ++k;
        }
        return count;
    }

    private static final class FloatHT {
        private Node[] table;
        private static final int MAX_SIZE = 0x40000000;
        private int mask;

        FloatHT(int minSize) {
            if (minSize > 0x40000000) {
                minSize = 0x40000000;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(float key) {
            int x = Float.floatToIntBits(key);
            return (x ^ x >>> 16) & this.mask;
        }

        boolean containsKey(float key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(float key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(float key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            float key;
            int value;
            Node next;

            Node(float key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class DoubleHT {
        private Node[] table;
        private static final int MAX_SIZE = 0x40000000;
        private int mask;

        DoubleHT(int minSize) {
            if (minSize > 0x40000000) {
                minSize = 0x40000000;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(double key) {
            long x = Double.doubleToLongBits(key);
            int y = (int)(x ^ x >>> 32);
            return (y ^ y >>> 16) & this.mask;
        }

        boolean containsKey(double key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(double key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(double key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            double key;
            int value;
            Node next;

            Node(double key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class CharHT {
        private Node[] table;
        private static final int MAX_SIZE = 65536;
        private int mask;

        CharHT(int minSize) {
            if (minSize > 65536) {
                minSize = 65536;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(char key) {
            return key & this.mask;
        }

        boolean containsKey(char key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(char key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(char key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            char key;
            int value;
            Node next;

            Node(char key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class ShortHT {
        private Node[] table;
        private static final int MAX_SIZE = 65536;
        private int mask;

        ShortHT(int minSize) {
            if (minSize > 65536) {
                minSize = 65536;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(short key) {
            return key & this.mask;
        }

        boolean containsKey(short key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(short key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(short key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            short key;
            int value;
            Node next;

            Node(short key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class LongHT {
        private Node[] table;
        private static final int MAX_SIZE = 0x40000000;
        private int mask;

        LongHT(int minSize) {
            if (minSize > 0x40000000) {
                minSize = 0x40000000;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(long key) {
            int x = (int)(key ^ key >>> 32);
            return (x ^ x >>> 16) & this.mask;
        }

        boolean containsKey(long key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(long key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(long key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            long key;
            int value;
            Node next;

            Node(long key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class IntHT {
        private Node[] table;
        private static final int MAX_SIZE = 0x40000000;
        private int mask;

        IntHT(int minSize) {
            if (minSize > 0x40000000) {
                minSize = 0x40000000;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.table = new Node[minSize];
        }

        int index(int key) {
            return (key ^ key >>> 16) & this.mask;
        }

        boolean containsKey(int key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(int key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(int key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            int key;
            int value;
            Node next;

            Node(int key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class Bucket {
        Node head;
        Node tail;

        private Bucket() {
        }

        void add(int value) {
            if (this.head == null) {
                this.head = this.tail = new Node(value);
            } else {
                this.tail = this.tail.next = new Node(value);
            }
        }

        int remove() {
            int v = this.head.value;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            return v;
        }

        static final class Node {
            int value;
            Node next;

            Node(int value) {
                this.value = value;
            }
        }
    }
}

