/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class CyclicEdgeDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int i;
        int countNonSharedEdges = 0;
        int L1 = p1.length();
        int L2 = p2.length();
        int[] successors2 = new int[L2];
        for (i = 0; i < L2; ++i) {
            successors2[p2.get((int)i)] = p2.get((i + 1) % L2);
        }
        for (i = 0; i < L1; ++i) {
            if (p1.get((i + 1) % L1) == successors2[p1.get(i)] || p1.get(i) == successors2[p1.get((i + 1) % L1)]) continue;
            ++countNonSharedEdges;
        }
        return countNonSharedEdges;
    }

    @Override
    public int max(int length) {
        if (length <= 3) {
            return 0;
        }
        if (length == 4) {
            return 2;
        }
        return length;
    }
}

