/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class ReversalDistance
extends AbstractPermutationDistanceMeasurer {
    private byte[] dist;
    private int PERM_LENGTH;
    private int maxd;

    public ReversalDistance() {
        this(10);
    }

    public ReversalDistance(int n) {
        if (n > 12 || n < 0) {
            throw new IllegalArgumentException("Requires 0 <= n <= 12.");
        }
        this.PERM_LENGTH = n;
        int fact = 1;
        for (int i = 2; i <= n; ++i) {
            fact *= i;
        }
        this.dist = new byte[fact];
        Permutation p = new Permutation(n, 0);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                p.reverse(i, j);
                int v = p.toInteger();
                p.reverse(i, j);
                this.dist[v] = 1;
            }
        }
        int visited = n * (n - 1) / 2 + 1;
        int start = 1;
        byte d = 1;
        while (visited < fact) {
            while (start < fact && this.dist[start] != 0 && this.dist[start] < d) {
                ++start;
            }
            for (int e = start; e < fact; ++e) {
                if (this.dist[e] != d) continue;
                p = new Permutation(n, e);
                for (int i = 0; i < n - 1; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        p.reverse(i, j);
                        int v = p.toInteger();
                        p.reverse(i, j);
                        if (v <= 0 || this.dist[v] != 0) continue;
                        this.dist[v] = (byte)(d + 1);
                        this.maxd = this.dist[v];
                        ++visited;
                    }
                }
            }
            d = (byte)(d + 1);
        }
    }

    @Override
    public int distance(Permutation p1, Permutation p2) {
        int n = p1.length();
        if (p2.length() != n || n != this.PERM_LENGTH) {
            throw new IllegalArgumentException("This distance measurer is configured for permutations of length " + this.PERM_LENGTH + " only.");
        }
        int[] inv1 = p1.getInverse();
        int[] r2 = new int[n];
        for (int i = 0; i < n; ++i) {
            r2[i] = inv1[p2.get(i)];
        }
        return this.dist[new Permutation(r2).toInteger()];
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return this.maxd;
    }
}

